/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/*
 * Nega Max - with Alpha Beta Pruning AI
 * 
 * Use the NegaMax search algorithm with alpha beta pruning to 
 * search for the best move to play
 * 
 */
 
#ifndef _AIMINIMAX_H_
#define _AIMINIMAX_H_

#include "AIHeuristics.h"


// Store the number of possible winning lines for a player
struct PlayerScores
{
	int connect4;
	int threeInLine;
	int twoInLine;
	int singles;
	
	PlayerScores ()
	{
		connect4 = 0;
		threeInLine = 0;
		twoInLine = 0;
		singles = 0;
	}
};

class AIMinimax : public AIHeuristics
{
private:

	GamesRules* rules;

	// Define the number of moves to search
	int ply;

	// Use this to recurse over the board evulating each move for both players
	// Use alpha-beta pruning to reduce the search space.
	int makeMoveMinimax(Board* board, int playerMax, int currentPlayer, int col, int row, int alpha, int beta, int depth);
	
	// Evaluate functions
	int evaluateBoard(Board* board, int player);
	
	void getPlayerScoresForBoard(Board* board, int player, PlayerScores* scores);
	void getVerticalPlayerScore(Board* board, int player, PlayerScores* scores);
	void getHorizontalPlayerScore(Board* board, int player, PlayerScores* scores);
	void getDiagonalPlayerScore(Board* board, int player, PlayerScores* scores);
	int calcScore(PlayerScores* maxScore, PlayerScores* minScore);

public:
	AIMinimax();
	virtual ~AIMinimax();
	
	virtual int playCounter(Board board, int player);
};

#endif //_AIMINIMAX_H_
