/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/*
 *  Heuristics AI
 * 
 *  Use basic rules and an influence map to decide on the next move
 * 
 */

#ifndef _AIHEURISTICS_H_
#define _AIHEURISTICS_H_

#include "GamesRules.h"
#include "iai.h"

class AIHeuristics : public IAI
{
protected:

	// Store the influence map
	int influenceMap[BOARD_COLS];
	void resetInfluenceMap();
	
	int getColumnToPlayFromInfluenceMap(int influMap[], Board* initBoard); 
	
private:

	
	GamesRules rules;
	
	// Defines the bias to apply to the best moves
	int attackBias;
	int defendBias;
	
	// Calculate the best move to make
	void calcBestMoveForPlayer(Board board, int player, int bias);
	
	// Calculate the best Move to make after the current move
	void calcBestNextMove(Board board, int player, int opponent, int bias);
	
	
	int getCellInfluence(Board board, int player, int col, int row, int bias);
	int calcInfluence(int numInLine, int numPossibleInLine, int bias);

public:
	AIHeuristics();
	virtual ~AIHeuristics();
	
	// Implement the IAI interface
	virtual int playCounter(Board board, int player);
};

#endif //_AIHEURISTICS_H_
