/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/*
 *  Container windows for the game, this draws and handles the GUI and events 
 */
 
#ifndef _GAME_H_
#define _GAME_H_

#include "General.h"
#include "engine/engine.h"

#define BOARD_BORDER_SIZE		10
#define WIN_HIGHLIGHT_REFRESH	500

class Game : public Window
{
private:

	C4Game* connect4Game;
	
	// Boards sizes
	int squareSize;
	int halfSquareSize;
	int discSize;
	SDL_Rect boardRect;
	
	// Winning flash time
	Uint32 winningFlashTime;
	bool winningFlashShow;	
	
	// Board graphics - Store the colours for the background and for each player
	SDL_Surface* counterGraphics[3];
	
	// Define the colour for the disc to highlight where the last move was
	Uint32 lastMoveColour;
	Uint32 hintMoveColour;
	Uint32 buttonColour;
	Uint32 buttonMouseOverColour;
	
	// Controls
	Label* message;
	Label* gamesWonLabel;
	Label* gamesLostLabel;
	Label* gamesDrawn;
	
	// Check boxes / radio buttons used for the difficulty settings
	CheckBox* aiEasyCheckBox;
	CheckBox* aiNormalCheckBox;
	CheckBox* aiHardCheckBox;
	
	// Font for the display
	Font* mainFont;
	
	// Button events
	void newGame();
	void undoMove();
	
	// AI level change events
	void setAIEasy();
	void setAINormal();
	void setAIHard();
	
	void setAILevel(AILevel level);
	
	// Get the computer to hint a move for the current player
	void getHint();
	
	// Messages
	void updateMessage(PlayStatus status);
	
public:
	Game(SDL_Surface* surface);
	virtual ~Game();
	
	// IWidget events
	virtual void animate();
	virtual void draw(SDL_Surface* surface);
	virtual bool keyPress(SDLKey key, SDLMod mod, Uint16 character);
	virtual bool mouseDown(int xMouse, int yMouse, int button);
};

#endif //_GAME_H_
