/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#ifndef _CONNECT4_H_
#define _CONNECT4_H_

#ifdef DREAMCAST
	#include <kos.h>
	extern uint8 romdisk[];
	KOS_INIT_FLAGS(INIT_DEFAULT);
	KOS_INIT_ROMDISK(romdisk);
#endif

// System includes
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "SDL.h"
#include "SDL_image.h"

#ifndef DREAMCAST
	#include "SDL_mixer.h"
#endif

// Game includes
#include "general/Log.h"
#include "General.h"
#include "wintoolkit/wintoolkit.h"
#include "Game.h"

// Include build varibles like version / installed packages etc
#if HAVE_CONFIG_H
# include <config.h>
#endif

// Game Constanst
#define APP_NAME "Connect4"						// Default the name of the application

const Uint32 FRAMES_PS = 30;					// Define the frame rate
const Uint32 FPS_DELAY = 1000/FRAMES_PS;		// Calculate the time for each frame from the frame rate

// Global Variables
SDL_Surface* screen = NULL;						// Main program screen
WindowManager* winman = WindowManager::Instance(); // Global refernce to the window manager

// Methods
void gameInitialise (SDL_Surface** screen);		// Initialise the game i.e. setup sdl
void gameCleanup ();							// Clean up - Free all resources / stop playing sounds	
void lockFrameRate (Uint32 startTime);			// Pause the game until the time has run out for the current frame


#endif //_CONNECT4_H_
