/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef TABSHEET_H
#define TABSHEET_H

#include "Control.h"
#include "Window.h"

#define MAX_NUM_OF_TABS				6
#define TAB_NAME_VERTICAL_BORDER	3
#define TAB_NAME_HORIZ_BORDER		6
#define TAB_WINDOW_BORDER			8

class TabSheet : public Control
{
private:

	char* tabNames[MAX_NUM_OF_TABS];	// The name of the tabs
	Window* tabs[MAX_NUM_OF_TABS];		// The tabs
	int numOfTabs;						// The current number of tabs
	
	Window* activeTab;					// The currently selected tab
	int activeTabIndex;
	
	// Drawing items
	Font* font;							// Define the font to use for the text of the tabs
	int tabNameHeight;					// The height of all of the tabs
	int tabNameWidth;					// Tab Width	
	
public:
	TabSheet(int x, int y, int width, int height);
	virtual ~TabSheet();
	
	// Tab properties
	Window* createTab(const char* tabName);
	void setActiveTabIndex(int index);
	
	Window* getTab(int index);
	Window* getActiveTab();
	int getActiveTabIndex();
	int getNumofTabs();
	int getTabName(int index, char* name, int bufferSize);
	
	void setFont(Font* font);							// Define the font used for the text on the button
	void setFont(char* fontFileName);					// Define the font used for the text on the button	
	
	int getTabNameHeight();
	int getTabNameWidth();
		
	// IWidget methods
	virtual void animate();
    virtual void draw(SDL_Surface* screenDest);
	virtual bool mouseDown(int x, int y, int button);
	virtual bool mouseUp(int x, int y, int button);
	virtual bool mouseMove(int x, int y);
	virtual bool keyPress( SDLKey key, SDLMod mod, Uint16 character );
	
};

#endif //TABSHEET_H
