/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef SOUND_H
#define SOUND_H

#include "WinToolKitGeneral.h"

class Sound
{
private:

	bool enabled;
	int effectVolume;
	int musicVolume;
	
	Mix_Music *music;						// Reference to the music mixer
	
public:

	Sound();
	virtual ~Sound();
	
	void playSound (const char* filename);
	void pauseSounds(bool pause);
	void playMusic(const char* filename);
	void pauseMusic(bool pause);
	void stopMusic();
	
};

#endif // SOUND_H





