/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "Sound.h"

Sound::Sound()
{
	enabled = true;
	effectVolume = 128;
	musicVolume = 128;
}

Sound::~Sound()
{
	Sound::stopMusic();
}

void Sound::playSound (const char* filename)
{
	// Exit if sound is disabled
	if (!enabled)
		return;
	
	Mix_Chunk* sound = Mix_LoadWAV(filename);
	if(!sound)
	{
	    Log::Instance()->log("Sound::playSound Mix_LoadWAV FAILED Loading (%s) Error %s\n", filename, Mix_GetError());
	    return;
	}
	
	// Set the volume for the sound effect
	Mix_VolumeChunk(sound, effectVolume);	
	
	// Start the sound playing on any available channel
	// and only play for a single loop
	if (Mix_PlayChannel(-1, sound, 0) < 0)
		Log::Instance()->log("Problem playing sound");
		
}

void Sound::pauseSounds(bool pause)
{
	// Pause or unpause all channels running
	if (pause)
		Mix_Pause(-1);
	else
		Mix_Resume(-1);
}

void Sound::playMusic(const char* filename)
{
	
	// Exit if sound is disabled
	if (!enabled)
		return;
	
	Sound::stopMusic();
	
	// Load up the music before we start playing it.
	music=Mix_LoadMUS(filename);
	if(!music)
	{
	    Log::Instance()->log("Mix_LoadMUS: [FAILED LOAD %s] %s\n", filename, Mix_GetError());
	    return;
	}
	
	// Set the volume
	Mix_VolumeMusic(musicVolume);
	
	// play music 
	if(Mix_PlayMusic(music,0)==-1)
	    Log::Instance()->log("Mix_PlayMusic: [FAILED LOAD] %s\n", Mix_GetError());
	
}

void Sound::pauseMusic(bool pause)
{
	if (pause)
		Mix_PauseMusic();
	else
		Mix_ResumeMusic();
}

void Sound::stopMusic()
{
	if (music)
	{
		Mix_HaltMusic();
		Mix_FreeMusic(music);
		music=NULL; // so we know we freed it.	
	}
}
