/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
 /*
  * A slider control.
  */
 
#ifndef SLIDER_H
#define SLIDER_H

#include "Control.h"

class Slider : public Control
{

private:

	int minValue;
	int maxValue;
	int currentValue;
	int stepValue;
	
	bool displayValue;
	bool blobHold;		// The user has pressed the mouse down on the blob so now move with the mouse

public:

	Slider(Rect rect);
	virtual ~Slider();
	
	// Accessor methods
	int getMaxValue();
	void setMaxValue(int value);
	int getMinValue();
	void setMinValue(int value);
	int getValue();
	void setValue(int value);
	int getStepValue();
	void setStepValue(int value);
		
	// Iwidget methods
	virtual void draw(SDL_Surface* screenDest);
	virtual bool mouseDown(int x, int y, int button);
	virtual bool mouseUp(int x, int y, int button);
	virtual bool mouseMove(int x, int y);
	virtual bool keyPress( SDLKey key, SDLMod mod, Uint16 character );
};

#endif // SLIDER_H
