/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
 /*
  * A control to display lists of items. If there are more items than can be displayed
  * then use a scroll bar to reach the remainder of the list.
  * 
  * Each item consists of a display part and a value. It can also handle double clicks
  * and fires the approate command
  */
 
 
#ifndef LISTBOX_H
#define LISTBOX_H

// Game includes
#include "Control.h"
#include "CallBack.h"
#include "WinToolKitGeneral.h"

#define SCROLLBAR_WIDTH 15

class ListBox : public Control
{

private:

	// A single item in the list
	struct listItem
	{
		char* item;
		char* value;	
	};
	
	// List of items
	List<listItem*> listItems;
	DListIterator<listItem*> currentItem;
	
	// Scroll bar details
	Uint32 blockHeight;
	Uint32 itemsPerScreen;
	bool scrollBars;
	int scrollStart;
	int scrollMoveAmount;
	SDL_Rect scrollBarRect;
	
	Uint32 highLightColour;
	Font* font;
	Uint32 clickTime;	// Use for double click. If within a certain time.
	
	void calcScrollBarPos();
	void setScrollStart(int start);
	void moveScrollBar(int amount);

public:

	ListBox(Rect rect);
	virtual ~ListBox();
	
	// Item handing methods
	void addItem(const char* item, const char* value);
	void clearList();
	bool itemSelected();
	const char* getSelectedItem();
	const char* getSelectedValue();
	void sort();
	
	// Display accessor methods
	void setHighLightColour(Uint32 col);
	void setFont(Font* font);							// Define the font used for the text on the button
	void setFont(char* fontFileName);					// Define the font used for the text on the button	
	virtual void setHeight(int height);
		
	// IWidget methods
	virtual void draw(SDL_Surface* screenDest);
	virtual bool mouseDown(int x, int y, int button);
	virtual bool mouseUp(int x, int y, int button);
	virtual bool mouseMove(int x, int y);
	virtual bool keyPress( SDLKey key, SDLMod mod, Uint16 character );
};

#endif // LISTBOX_H
