/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
#include "Image.h"

Image::Image(Rect size) : Control(size)
{
	this->image	= NULL;
	screenRect.x = this->x;
	screenRect.y = this->y;
	screenRect.w = this->width;
	screenRect.h = this->height;
}

Image::~Image()
{
	if (this->image != NULL)
	{
		SDL_FreeSurface(this->image);
		this->image = NULL;
	}
}


void Image::loadImage(const char* imagePath)
{
	// Clean up the image if already loaded
	if (this->image != NULL)
		SDL_FreeSurface(this->image);
	
	// Load the onto the button.
	this->image = IMG_Load(imagePath);

	if (!this->image)
		Log::Instance()->die(1, SV_ERROR, "Trouble loading image %s", imagePath);
}
	
	
void Image::draw(SDL_Surface* screenDest)
{
	if (this->visible && this->image)
	{
		SDL_BlitSurface(this->image, NULL, screenDest, &screenRect);	
	}
}
