/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/*
 * The Connect 4 board
 * 
 * 7x6 2D array used to store the counters
 * 
 */
 
#ifndef _BOARD_H_
#define _BOARD_H_

#include "../General.h"

class Board
{
public:

	// Use a 2D array to store the board
	// Empty cells = 0
	// Player 1 cells = 1
	// Player 2 cells = 2
	int board[BOARD_COLS][BOARD_ROWS];

	Board();
	virtual ~Board();
	
	// Reset the board for the start of the next game
	void reset();
	
	// Check if the board is full
	bool isFull();
	
	// Check if the column is full
	bool isColumnFull(int column);
	
	// Find the next free row to play in the selected column
	int nextSquareFree(int column);
	
	// Write out the contents of the board to the log file
	void logBoard();
};

#endif //_BOARD_H_
