/*
 *  Dwarf City
 *  Copyright (C) 2005  
 *  					Adam Child (adam@dwarfcity.co.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef GENERAL_H
#define GENERAL_H

// System includes
#include <math.h>
#include <string.h>
#include <iostream>
#include <fstream>

// Game includes
#include "general/Log.h"
#include "wintoolkit/wintoolkit.h"

 // Define NULL
#ifndef NULL
#define NULL		((void *)0)
#endif

// Constanst
#ifdef DREAMCAST
	#define APP_WIDTH 		640
	#define APP_HEIGHT		480
#else
	#define APP_WIDTH 		800
	#define APP_HEIGHT		600
#endif

#define LOG_THRESHOLD	SV_DEBUG
#define BOARD_COLS		7
#define BOARD_ROWS		6

#ifdef PACKAGE_DATA_DIR
#define GFX_PATH		PACKAGE_DATA_DIR "/"
#else
#define GFX_PATH		"../"
#endif

#define MAIN_FONT		GFX_PATH "gfx/font-bauhaus93-blue-18pt.png"

// Macros
#define max(a,b)	(((a)>(b))?(a):(b))
#define min(a,b)	(((a)<(b))?(a):(b))
#define radians(a)	((a) * M_PI / 180)
#define degrees(a) 	((a) * 180 / M_PI)
#define round(a) 	(floor((a) + 0.5))
#define random(a) 	((a) * rand() / RAND_MAX)

// Sort
int compareChars (const void * a, const void * b);

#endif // GENERAL_H

