#include "geki5.h"
#include "extern.h"

//========================================
// ᡼(ե졼ढ)
//========================================
void DrawImageFrame(CharacterData *my)
{
  KXL_PutImage(my->Spr[my->FrameNo]->Image, my->X, my->Y);
}

//========================================
// äդ
//========================================
RcHitEnum HitDelete(CharacterData *my, CharacterData *your)
{
  return RcHitDel;
}

//========================================
// äƤؤä
//========================================
RcHitEnum HitNone(CharacterData *my, CharacterData *your)
{
  return RcHitNone;
}

//========================================
// ܰưʥե졼ʤ
//========================================
RcHitEnum MoveStandardNoFrame(CharacterData *my)
{
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr[0]->Image->Height ||
      my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr[0]->Image->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  return RcHitNone;
}

//========================================
// ܰưʥե졼ढ
//========================================
RcHitEnum MoveStandardFrame(CharacterData *my)
{
  my->FrameNo = (++ my->FrameNo) % my->FrameMax;
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr[0]->Image->Height ||
      my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr[0]->Image->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  return RcHitNone;
}

//========================================
// Ѽ
//========================================
Uint16 GetDirection(CharacterData *my, CharacterData *your)
{
  KXL_Rect src, dest;

  src.Left    = my->X;
  src.Top     = my->Y;
  src.Width   = my->Spr[my->FrameNo]->Image->Width;
  src.Height  = my->Spr[my->FrameNo]->Image->Height;
  dest.Left   = your->X;
  dest.Top    = your->Y;
  dest.Width  = your->Spr[your->FrameNo]->Image->Width;
  dest.Height = your->Spr[your->FrameNo]->Image->Height;
  return KXL_GetDirection(src, dest);
}

//========================================
// ٤ˤûͼ
//========================================
void GetDirectionAdd(Uint16 direction, Sint16 *ax, Sint16 *ay, Uint16 speed)
{
  KXL_GetDirectionAdd(direction, ax, ay);
  *ax *= speed;
  *ay *= speed;
}

//========================================
// ơꥢ&४С
//========================================
void ClearAndGameOver(void)
{
  static Uint16 no;
  Uint16 y[] = {10, 20, 30, 40, 50, 60, 70, 80, 90, 80, 70, 60, 50, 40, 30, 20, 10, 0};
  Uint16 i;
  Uint8 *str[3] = {"Clear", "GameOver", "See you next..."};

  if (Root->Cnt == 0) {
    if (Root->MainFlag == MainClear) {
      no = Root->Stage == 7 ? 2 : 0;
	  if (no == 2) ScoreRanking(); //Save Ranking
    } else {
      ScoreRanking();
      no = 1;
    }
  }
  KXL_Font("-bitstream-charter-bold-*-normal-*-60-*-*-*-*-*-*-*", 0x00, 0x00, 0x00);
  for (i = 0; i < 2; i ++) {
    KXL_Font(NULL, i * 0xff, i * 0xff, i * 0xff);
    KXL_PutText(UP_LEFT + 2 + (WIDTH - KXL_TextWidth(str[no])) / 2,
		UP_TOP + 100 + 2 - i + y[Root->Cnt % 18],
		str[no]);
  }
  KXL_Font( "-adobe-courier-bold-r-normal--14-*-*-*-*-*-iso8859-1", 0xff, 0xff, 0xff);
  if (Root->Cnt >= 50) {
    KXL_DrawRectangle(UP_LEFT, UP_TOP,
		      WIDTH, (Root->Cnt - 50) * 8, True);
    KXL_DrawRectangle(UP_LEFT, UP_BOTTOM - (Root->Cnt - 50) * 8,
		      WIDTH, (Root->Cnt - 50) * 8, True);
  }
  if (++ Root->Cnt == 80) {
    //UnLoadStageData();
    if (Root->MainFlag == MainClear) {
      Root->MainFlag = MainStart;
      if (++ Root->Stage == 8) {
	KXL_PlaySound(SE_BGM, KXL_SOUND_STOP_ALL);
	Root->MainFlag = MainOpening;
      }
    } else {
      KXL_PlaySound(SE_BGM, KXL_SOUND_STOP_ALL);
      Root->MainFlag = MainOpening;
    }
    Root->Cnt = 0;
  }
}

//========================================
// ॹ
//========================================
void Start(void)
{
  if (Root->Cnt == 0) {
    Uint8 i;

    KXL_PlaySound(SE_BGM, KXL_SOUND_STOP_ALL);
    for (i = 0; i < MAX_YOUR; i ++)
      Root->Your[i]->Chr.Active = False;
    for (i = 0; i < MAX_MY; i ++)
      Root->My[i]->Chr.Active = False;
    CreateMy();
    LoadStageData();
  }
  KXL_DrawRectangle(UP_LEFT, UP_TOP,
		    WIDTH, HEIGHT / 2 - Root->Cnt * 8, True);
  KXL_DrawRectangle(UP_LEFT, UP_TOP + HEIGHT / 2 + Root->Cnt * 8,
		    WIDTH, HEIGHT / 2 - Root->Cnt * 8, True);
  if (++ Root->Cnt == 25) {
    Root->MainFlag = MainGame;
    KXL_PlaySound(SE_BGM, KXL_SOUND_PLAY_LOOP);
  }
}

//========================================
// ե᡼
//========================================
void Infomation(void)
{
  Uint8 text[4][30];
  Uint8 i, j;

  if (Root->Score > Root->HiScore)
    Root->HiScore = Root->Score;
  sprintf(text[0], "Score %03d", Root->Score);
  sprintf(text[1], "Life %02d",  Root->Life);
  sprintf(text[2], "Stage %02d", Root->Stage + 1);
  sprintf(text[3], "Power %03d", Root->MyPower);

  for (j = 0; j < 4; j ++) {
    for (i = 0; i < 2; i ++) {
      KXL_Font(NULL, i * 0xff, i * 0xff, i * 0xff);
      KXL_PutText(UP_LEFT +  40 + j * 120 + 2 - i, UP_TOP + 12 + 2 - i, text[j]);
    }
  }
}

