#include "geki5.h"
#include "extern.h"

//========================================
// ϰ
//========================================
void SetPer(PixData *my, float per)
{
  my->r.Width  = (Uint16)((float)my->Image->Width  * per + 0.5);
  my->r.Height = (Uint16)((float)my->Image->Height * per + 0.5);
  my->r.Left   = (my->Image->Width  - my->r.Width)  / 2;
  my->r.Top    = (my->Image->Height - my->r.Height) / 2;
}

//========================================
// ᡼ʬ
//========================================
PixData **LoadImageSplit(Uint8 *fname, Uint8 blend, Uint16 max, float per)
{
  Uint8 filename[64];
  Uint16 w, h, i;
  KXL_Image *img;
  PixData **new;
  KXL_Rect rect;

  // bmpեɤ߹
  sprintf(filename, BMP_PATH "/%s.bmp", fname);
  img = KXL_LoadBitmap(filename, blend);
  w = img->Width / max;
  h = img->Height;
  // ᡼ʬ
  new = (PixData **)KXL_Malloc(sizeof(PixData *) * max);
  for (i = 0; i < max; i ++) {
    new[i] = (PixData *)KXL_Malloc(sizeof(PixData));
    rect.Left   = i * w;
    rect.Top    = 0;
    rect.Width  = w;
    rect.Height = h;
    new[i]->Image = KXL_CopyImage(img, rect);
    SetPer(new[i], per);
  }
  // ɤ߹Image
  KXL_DeleteImage(img);
  return new;
}

//========================================
// ᡼
//========================================
PixData *LoadImage(Uint8 *fname, Uint8 blend, float per)
{
  Uint8 filename[64];
  PixData *new;

  // bmpեɤ߹
  sprintf(filename, BMP_PATH "/%s.bmp", fname);
  new = (PixData *)KXL_Malloc(sizeof(PixData));
  new->Image = KXL_LoadBitmap(filename, blend);
  SetPer(new, per);
  return new;
}

//========================================
// ᡼
//========================================
PixData **LoadImages(Uint8 *fname, Uint8 blend, Uint16 max, float per)
{
  PixData **new;
  Uint8 filename[64];
  Uint16 i;

  new = (PixData **)KXL_Malloc(sizeof(PixData *) * max);
  for (i = 0; i < max; i ++) {
    sprintf(filename, "%s%d", fname, i + 1);
    new[i] = LoadImage(filename, blend, per);
  }
  return new;
}

//========================================
// ᡼
//========================================
void UnLoadImage(PixData *my)
{
  KXL_DeleteImage(my->Image);
}

//========================================
// ᡼
//========================================
void UnLoadImages(PixData **my, int max)
{
  while (max)
    UnLoadImage(my[-- max]);
  free(my);
}

//========================================
// ᡼
//========================================
void CreateImage(void)
{
  PixMy         = LoadImageSplit("my", 0, 2, 0.6);
  PixItem       = LoadImageSplit("item", 0, 1, CHECK_PER);
  PixMShot      = LoadImageSplit("mshot", 0, 1, CHECK_PER);
  PixEShot      = LoadImageSplit("eshot", 0, 4, CHECK_PER);
  PixBomb       = LoadImageSplit("bomb", 0, 13, 0.0);
  PixEnemy1     = LoadImageSplit("enemy1", 0, 8, CHECK_PER);
  PixEnemy2     = LoadImageSplit("enemy2", 0, 3, CHECK_PER);
  PixEnemy3     = LoadImageSplit("enemy3", 0, 2, CHECK_PER);
  PixBack       = KXL_LoadBitmap(BMP_PATH "/back.bmp", 255);
}

//========================================
// ᡼
//========================================
void DeleteImage(void)
{
  UnLoadImages(PixMy, 2);
  UnLoadImages(PixItem, 1);
  UnLoadImages(PixMShot, 1);
  UnLoadImages(PixEShot, 4);
  UnLoadImages(PixBomb, 13);
  UnLoadImages(PixEnemy1, 8);
  UnLoadImages(PixEnemy2, 3);
  UnLoadImages(PixEnemy3, 2);
  KXL_DeleteImage(PixBack);
}

//========================================
// ơǡɤ߹
//========================================
void LoadStageData(void)
{
  FILE *fp;
  Uint8 buff[256];
  Sint32 n, x, y, w;

  Root->YourMax = 0;
  sprintf(buff, "%s/stage%d.dat", DATA_PATH, Root->Stage + 1);
  if ((fp = fopen(buff, "r")) == NULL) {
    fprintf(stderr, "sorry, waito to next update.\n");
    return;
  }
  while (fgets(buff, 255, fp)) {
    if (buff[0] == ';' || buff[0] == '\n')
      continue;
	
	//The next sscanf fails in real Dreamcast, so use an alternative method...
	#ifdef DREAMCAST
      int cnt=0;
      char *str=(char *)buff;
      Uint8 *st[4];

      for (cnt=0; cnt<4; ) {
        if ((st[cnt] = strsep(&str, ",")) == NULL)
          break;
        if (*st[cnt] != '\0')
          cnt++;
      }

      if(cnt==4) {
        x=atoi(st[0]);
        y=atoi(st[1]);
        n=atoi(st[2]);
        w=atoi(st[3]);
      }
	#else
    sscanf(buff, "%d, %d, %d, %d", &x, &y, &n, &w);
	#endif

    switch (n) {
    case 1:
      CreateEnemy1(UP_LEFT + 8 + x * 64 + (64 - PixEnemy1[0]->Image->Width) / 2,
		   UP_TOP + 20 + y * 64 + (64 - PixEnemy1[0]->Image->Height) / 2,
		   w);
      break;
    case 2:
      CreateEnemy2(UP_LEFT + 8 + x * 64 + (64 - PixEnemy2[0]->Image->Width) / 2,
		   UP_TOP + 20 + y * 64 + (64 - PixEnemy1[0]->Image->Height) / 2,
		   w);
      break;
    case 3:
      CreateEnemy3(UP_LEFT + 8 + x * 64 + (64 - PixEnemy3[0]->Image->Width) / 2,
		   UP_TOP + 20 + y * 64 + (64 - PixEnemy1[0]->Image->Height) / 2,
		   w);
      break;
    }
    Root->YourMax ++;
  }
  Root->YourCnt = Root->YourMax;
  fclose(fp);
}

//========================================
// ơǡ
//========================================
void UnLoadStageData()
{
}
