/* font.c
 *
 * (c) 2000 Dan Potter
 * (C) 2001 David Kuder
 */

#include <stdio.h>
#include <stdarg.h>

/* You must call this function to setup a font to use for
   the rest of the drawing functions. The font should be composed
   of 256 bitmapped 8-pixel-wide rows (1 byte per row). */
int		font_height = 0;
unsigned char *	font_bm = NULL;
void pcfont_set(unsigned char * fbm, int fh) {
	font_height = fh;
	font_bm = fbm;
}

/* Draws a single character using the loaded font. Assumes a
   PM_RGB565 display mode. */
void pcfont_char(uint16 *out, int buf_width, uint16 color, int ch) {
	int offs = ch * font_height;
	int x, y;
	
	for (y=0; y<font_height; y++) {
		int mask = 0x80;
		for (x=0; x<8; x++) {
			unsigned short pixel = 0;
			if (font_bm[offs+y] & mask) {
				pixel = color;
				out[y*buf_width+x] = pixel;
			}
			mask >>= 1;
		}
	}
}

/* Draws an entire string using the loaded font. */
void pcfont_string(uint16 *out, int buf_width, unsigned short color, char *str) {
	while (*str) {
		pcfont_char(out, buf_width, color, *str);
		out += 8; str++;
	}
}

/* Uses printf() style formatting to draw a string. */
void pcfont_stringf(uint16 *out, int buf_width, unsigned short color, char *fmt, ...) {
	va_list		args;
	char		pbuf[2048];

	va_start(args, fmt);
	vsprintf(pbuf, fmt, args);
	va_end(args);

	pcfont_string(out, buf_width, color, pbuf);
}
