#include <stdio.h>
#include "KXL.h"

extern KXL_Window *KXL_Root;

//==============================================================
//  Σ£ͣФ򣱣󲽤
//  8bpsǡ
//        16bpsX᡼
//        ѥå
//==============================================================
void KXL_CreateBitmap8to16(Uint8 *from, KXL_Image *to, KXL_RGBE *rgb, Uint8 blend)
{
  Uint32 x, y, offset, no;

  for (y = 0; y < to->Height; y ++) {
    for (x = 0; x < to->Width; x ++) {
      // եåȷ׻
      offset = (y * to->TXRWidth + x);
      no = from[y * to->Width + x];
      if (no == blend) { // ѥåֹˤ
	to->Buffer[offset] = 0x0000;
      } else {
	// 000rrrrr, 000ggggg, 000bbbbb
	//            |
	// gg0bbbbb, rrrrrggg
	if (!(rgb[no].r | rgb[no].g | rgb[no].b)) { // ʹ̵
	  to->Buffer[offset] = 0x8841;
	} else {
	  to->Buffer[offset] = 0x8000 | (rgb[no].r<<10) | (rgb[no].g<<5) | rgb[no].b;
	}
      }
    }
  }
}


//==============================================================
//  Σ£ͣФ򣱣󲽤
//  8bpsǡ
//        1bpsX᡼
//==============================================================
void KXL_CreateBitmap8to1(Uint8 *from, KXL_Image *to, Uint8 blend)
{
  Uint16 x, y, offset, no;
  
  for (y = 0; y < to->Height; y ++) {
    for (x = 0; x < to->Width; x ++) {
      // եåȷ׻
      offset = ((y * to->Width) / 8) + (x >> 3);
      no = from[y * to->Width + x];
      if (no != blend)
	to->Mask[offset] |= 1 << (x & 7);
      else
	to->Mask[offset] &= ~(1 << (x & 7));
    }
  }
}

//==============================================================
//  ӥåȥޥåץإåɤ߹
//  ե̾
//        إåΥݥ
//==============================================================
void KXL_ReadBitmapHeader(Uint8 *filename, KXL_BitmapHeader *hed)
{
  FILE *fp;
  Uint16 i, j;
  Uint8  data;

  // եɤ߹Ѥǳ
  if ((fp = fopen(filename,"rb")) == 0) {
    fprintf(stderr, "KXL error message\n'%s' is open error\n", filename);
    exit(1);
  }
  // إåɤ߹
  fread(hed->magic, 1, 2, fp);
  if (hed->magic[0] != 'B' || hed->magic[1] != 'M') {
    fprintf(stderr, "KXL error message\n'%s' is not bitmap file\n", filename);
    exit(1);
  }
  hed->file_size  = KXL_ReadU32(fp);
  hed->reserved1  = KXL_ReadU16(fp);
  hed->reserved2  = KXL_ReadU16(fp);
  hed->offset     = KXL_ReadU32(fp);
  hed->hed_size   = KXL_ReadU32(fp);
  hed->width      = KXL_ReadU32(fp);
  hed->height     = KXL_ReadU32(fp);
  hed->plane      = KXL_ReadU16(fp);
  hed->depth      = KXL_ReadU16(fp);
  // 4 or 8bpp ʳϥݡȳ
  if (hed->depth > 8) {
    fprintf(stderr, "KXL error message\n'%s' %dbps not support\n", 
	    filename, hed->depth);
    exit(1);
  }
  hed->lzd        = KXL_ReadU32(fp);
  hed->image_size = KXL_ReadU32(fp);
  // ᡼ʤнλ
  if (hed->image_size == 0) {
    fprintf(stderr, "KXL error message\n'%s not found image size\n",
	    filename);
    exit(1);
  }
  hed->x_pixels   = KXL_ReadU32(fp);
  hed->y_pixels   = KXL_ReadU32(fp);
  hed->pals       = KXL_ReadU32(fp);
  hed->pals2      = KXL_ReadU32(fp);
  // ѥѥåȿ
  if (hed->pals == 0)
    hed->pals = 2 << (hed->depth - 1);
  else
    hed->pals ++;
  // 顼ޥå׼
  hed->rgb = (KXL_RGBE *)KXL_Malloc(sizeof(KXL_RGBE) * hed->pals);
  for (i = 0; i < hed->pals; i ++) {
    hed->rgb[i].b = fgetc(fp);
    hed->rgb[i].g = fgetc(fp);
    hed->rgb[i].r = fgetc(fp);
    hed->rgb[i].e = fgetc(fp);
    // X16bppʤƤ
    hed->rgb[i].b /= 8;
    hed->rgb[i].g /= 8;
    hed->rgb[i].r /= 8;
  }
  // 4ܿ
  hed->w = ((hed->width + 3) / 4) * 4;
  // ǡΰ
  if (hed->depth == 8)
    hed->data = (Uint8 *)KXL_Malloc(hed->image_size);
  else
    hed->data = (Uint8 *)KXL_Malloc(hed->image_size * 2);
  // ǡ
  if (hed->depth == 8) {
    // 8bppbmpɤ߹߳Ǽ
    for (i = 0; i < hed->height; i++) {
      // ǽ饤󤫤ɤ߹
      fseek(fp, hed->offset + (hed->height - i - 1) * hed->w, 0); 
      fread(&(hed->data[i * hed->w]), hed->w, 1, fp);
    }
  } else {
    Uint32 w = (((hed->width / 2) + 3) / 4) * 4;
    // 4bppbmpɤ߹߳Ǽ
    for (i = 0; i < hed->height; i++) {
      // ǽ饤󤫤ɤ߹
      fseek(fp, hed->offset + (hed->height - i - 1) * w, 0); 
      for (j = 0; j < w; j ++) {
	data = fgetc(fp);
	hed->data[i * hed->w + j * 2 + 0] = data >> 4;
	hed->data[i * hed->w + j * 2 + 1] = data & 0x0f;
      }
    }
  }
  hed->depth = 8;
  fclose(fp);
}
