//====================================================
// Geki5
// Copyright (C) 2001, kacchan
// E-M@il address   fc3srx@mwnet.or.jp
// Homepage address http://www2.mwnet.or.jp/~fc3srx7
//====================================================
#ifndef _GEKI5_H_
#define _GEKI5_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <KXL.h>

// 
#define RM(n) (rand() % (n))

// ե졼졼
#define FRAME_RATE 30

// ɥ
#define FREE         80
#define WIDTH        528
#define HEIGHT       400
#define UP_LEFT      FREE
#define UP_TOP       FREE
#define UP_RIGHT     (FREE + WIDTH - 1)
#define UP_BOTTOM    (FREE + HEIGHT -1)
#define PIC_WIDTH    (FREE * 2 + WIDTH)
#define PIC_HEIGHT   (FREE * 2 + HEIGHT)

// Ϣ
#define KeyUp    KXL_KEY_Up
#define KeyDown  KXL_KEY_Down
#define KeyRight KXL_KEY_Right
#define KeyLeft  KXL_KEY_Left
#define KeyShot  KXL_KEY_z
#define KeyPause KXL_KEY_s
#define KeyQuit  KXL_KEY_Escape

#define KNone      0
#define KUp        (1L << 0)
#define KDown      (1L << 1)
#define KRight     (1L << 2)
#define KLeft      (1L << 3)
#define KShot      (1L << 4)
#define KPause     (1L << 5)
#define KQuit      (1L << 6)

#define KUpMask    ~KUp
#define KDownMask  ~KDown
#define KRightMask ~KRight
#define KLeftMask  ~KLeft
#define KShotMask  ~KShot
#define KPauseMask ~KPause
#define KQuitMask  ~KQuit

// 饯μ̻
#define AttrNone     0
#define AttrMy       (1L << 0)
#define AttrMShot    (1L << 1)
#define AttrEnemy    (1L << 2)
#define AttrEShot    (1L << 3)
#define AttrItem     (1L << 4)

// ϰ
#define CHECK_PER    0.85

// 饯
#define MAX_YOUR    80
#define MAX_MY      8

#define SE_BGM      0

#define SE_BOMB     0
#define SE_POW      1
#define SE_GO       2
#define SE_HIT      3

// 
/*enum {
  SE_BGM = 0,
  SE_BOMB,
  SE_POW,
  SE_GO,
  SE_HIT
};*/

// ᥤư
typedef enum {
  MainOpening,
  MainStart,
  MainGame,
  MainClear,
  MainGameOver,
  MainEnding,
  MainPause
} MainEnum;

// ư
typedef enum {
  RcHitNone,
  RcHitDel,
  RcHitBomb,
} RcHitEnum;

// ᡼
typedef struct {
  KXL_Image *Image;
  KXL_Rect r;
} PixData;

// 饯
typedef struct {
  Bool   Active;                  // ե饰
  Uint16 Attr;                    // ̻
  Uint16 Target;                  // å
  Sint16 MoveFlag;                // ưե饰
  Sint16 Cnt2;                    // 󥿡2
  Sint16 Cnt3;                    // 󥿡3
  Sint16 Cnt4;                    // 󥿡4
  Sint16 Cnt5;                    // 󥿡5
  Sint16 Cnt6;                    // 󥿡6
  Sint16 Hp;                      // ѵ
  Uint16 X, Y;                    // ɸ
  Uint32 CntX, CntY;              // ưɸ
  Sint16 AddX, AddY;              // ư
  Uint8  FrameCnt;                // ե졼५
  Uint8  FrameNo;                 // ե졼ֹ
  Uint8  FrameMax;                // ե졼
  PixData **Spr;                  // ᡼
} CharacterData;

// 饯Хå
typedef struct {
  CharacterData Chr;
  void (*Draw)(CharacterData *my);
  RcHitEnum (*Move)(CharacterData *my);
  RcHitEnum (*Hit)(CharacterData *my, CharacterData *your);
} CharacterObject;

// δ
typedef struct {
  MainEnum MainFlag;               // ᥤư
  Uint16   Key;                    // ϥ
  Uint8    MyNo;                   // ʬ¦Υ饯
  Uint8    YourNo;                 // Ũ¦Υ饯()
  Uint16   YourMax;                // Ũ¦Υ饯(å)
  Uint8    YourCnt;                // Ũ¦Υ饯()
  Uint8    Stage;                  // ơ
  Uint32   Score;                  // 
  Uint32   HiScore;                // ϥ
  Sint8    Life;                   // ʬΥ饤
  Uint8    MyPower;                // ʬΥѥ
  Uint8    MyShots;                // ƿ
  Uint8    MyShotsMax;             // ƿ
  Uint8    MyShotPower;            // Ƥΰ
  Sint16   Cnt;                    // ΤΥ󥿡
  CharacterObject **My;            // ʬ¦Υ饯Хå
  CharacterObject **Your;          // Ũ¦Υ饯Хå
  Uint16   LX, RX;                 // üŨ饯κɸ
} RootData;

// 󥭥󥰾
typedef struct {
  Uint32 Score;
  Uint8 Stage;
  Uint8 Name[16];
} RankingData;

#endif
