/*
**  Geki2
**  Copyright (C) 1999-2001, kacchan
**  E-M@il address   fc3srx@mwnet.or.jp
**  Homepage address http://www2.mwnet.or.jp/~fc3srx7
*/
#ifndef _GEKI2_H_
#define _GEKI2_H_

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <KXL.h>

#define FRAME_RATE 30

#define KeyUp    KXL_KEY_Up
#define KeyDown  KXL_KEY_Down
#define KeyRight KXL_KEY_Right
#define KeyLeft  KXL_KEY_Left
#define KeyShot  KXL_KEY_z
#define KeyPause KXL_KEY_s

/** ޥ **/
#define KNone      0
#define KUp        (1L << 0)
#define KDown      (1L << 1)
#define KRight     (1L << 2)
#define KLeft      (1L << 3)
#define KShot      (1L << 4)
#define KPause     (1L << 5)

#define KUpMask    ~KUp
#define KDownMask  ~KDown
#define KRightMask ~KRight
#define KLeftMask  ~KLeft
#define KShotMask  ~KShot
#define KPauseMask ~KPause

/** 饯μ̻**/
#define AttrNone     0
#define AttrMy       (1L << 0)
#define AttrMShot    (1L << 1)
#define AttrEnemy    (1L << 2)
#define AttrEShot    (1L << 3)
#define AttrItem     (1L << 4)
#define AttrEBomb    (1L << 5)

/** ɥ **/
#define DRAW_WIDTH   550
#define DRAW_HEIGHT  400
#define FREE_AREA    60
#define PICT_WIDTH   (DRAW_WIDTH + FREE_AREA * 2)
#define PICT_HEIGHT  (DRAW_HEIGHT + FREE_AREA * 2)
#define AREA_LX      FREE_AREA
#define AREA_LY      FREE_AREA
#define AREA_RX      (PICT_WIDTH - FREE_AREA)
#define AREA_RY      (PICT_HEIGHT - FREE_AREA)
#define CHECK_PER    0.7

/** Ƽ **/
#define MAX_YOUR    160 /** Ũ&Ũ **/
#define MAX_MY      48  /** ץ쥤䡼&ץ쥤䡼 **/
#define BOSS_NO     0

/**  **/

#define SE_BGM1     0
#define SE_BGM2     1
#define SE_BGM3     2
#define SE_BGM4     3
#define SE_BOSS     4

#define SE_BOMB     0
#define SE_WARNING  1
#define SE_LASER    2
#define SE_POW      3
#define SE_GO       4

/** ܡ **/
#define BALL_SHOT    0
#define BALL_MISSILE 1
#define BALL_HP      2

/** ᥤư **/
typedef enum {
  MainOpening,
  MainGame,
  MainClear,
  MainGameOver,
  MainEnding,
  MainPause
} MainEnum;

/*ư*/
typedef enum {
  RcHitNone,
  RcHitDel,
  RcHitBomb,
  RcHitBoss
} RcHitEnum;

/** ԥå **/
typedef struct {
  KXL_Image *Image;
  KXL_Rect r;
} PixData;

/** 饯ǡ **/
typedef struct {
  Bool    Active;     /** ɽ? **/
  Uint16  Attr;       /** ̻ **/
  Uint16  Target;     /** å **/
  Uint16  Strong;     /**  **/
  Sint16  Cnt1;       /**  **/
  Sint16  Cnt2;       /**  **/
  Sint16  Cnt3;       /**  **/
  Sint16  Cnt4;       /**  **/
  Sint16  Cnt5;       /**  **/
  Sint16  Cnt6;       /**  **/
  Uint16  Etc;        /**  **/
  Sint16  Hp;         /**  **/
  Uint32  Score;      /**  **/
  Sint16  X, Y;       /** ץ饤Ⱥɸ **/
  Uint32  CntX, CntY; /** ץ饤Ȱư **/
  Sint16  AddX, AddY; /** ץ饤Ȱư̲û **/
  Uint8   FrameNo;    /** ե졼No. **/
  Uint8   FrameMax;   /** ե졼 **/
  PixData **Spr;      /** ᡼ **/
} CharacterData;

/** ѥ饯ǡ **/
typedef struct {
  CharacterData Chr;
  void (*Draw)(CharacterData *my);
  RcHitEnum (*Move)(CharacterData *my);
  RcHitEnum (*Hit)(CharacterData *my, CharacterData *your);
} CharacterObject;

/**  **/
typedef struct {
  Uint8    StageMax;    /*Ũиѥ*/
  Uint16   ScrollCnt;   /*طʥ륫*/
  Uint16   EnemyCnt;    /*Ũи*/
  MainEnum MainFlag;    /*ᥤե饰*/
  Uint16   Key;         /**/
  Uint8    MyNo;
  Uint8    YourNo;
  Uint8    Stage;       /*ơNo.*/
  Uint8    StageLoop;   /*ơ롼׿*/
  Uint32   Score;       /**/
  Uint32   HiScore;     /*ϥ*/
  Sint16   MyHpMax;     /*ѵϺ*/
  Sint16   MyHp;        /*ѵ*/
  Uint8    MyLaserPower;/*졼ѥ*/
  Uint8    MyShot;      /*ѥ*/
  Uint8    MyMissile;   /*ߥѥ*/
  Uint16   Cnt;         /*ѥ*/
  Bool     WaitFlag;    /*ݡե饰*/
  Sint16   BossHpMax;   /*ܥѵ*/
  CharacterObject **My;
  CharacterObject **Your;
} RootData;

/*󥭥*/
typedef struct {
  Uint32 Score;
  Uint8 Stage;
  Uint8 Loop;
  Uint8 Name[16];
} RankingData;

/*ơǡ*/
typedef struct {
  Uint16 Time;         /* Ũи */ 
  Uint8  CreateNo;     /* ŨNo. */
  Uint8  Max;          /* Ũи */
  Uint16 Step;         /* Ũиֳ */
  Uint16 StepTime;
  Bool Flag;
} StageData;

typedef struct {
  Sint16 x, y;
  Sint16 add;
} _star;

#endif
