#include "geki4.h"
#include "extern.h"

//Dreamcast: Use VMU to store Rankings file
#ifdef DREAMCAST
	#include <kos.h>
	#include "dreamcast_icon.h"
#endif

/**********************
  󥭥
 **********************/
int ScoreRanking(void)
{
  Uint16 i, j;
	
  for (i = 0; i < 5; i ++)
    if (Ranking[i]->Score < Root->Score)
      break;
  if (i == 5)
    return 0;
  if (i != 4) {
    for (j = 4; j > i; j --)
      memcpy(Ranking[j], Ranking[j - 1], sizeof(RankingData));
  }
  Ranking[i]->Score = Root->Score;
  Ranking[i]->Stage = Root->Stage;
  //DC: Use a Generic name (Linux version uses getuid())
  #ifdef DREAMCAST
	  strcpy(Ranking[i]->Name, "DCPlayer");
  #else
      struct passwd *pw;
	  if (!(pw = getpwuid(getuid())))
		sprintf(Ranking[i]->Name, "%d", getuid());
	  else
		strcpy(Ranking[i]->Name, pw->pw_name);
  #endif
  WriteScore();
  
  return 0;
}

/**********************
  ɤ߹
 **********************/
void ReadScore(void)
{
  FILE *fp;
  Uint16 i;

  #ifdef DREAMCAST
  DC_LoadFromVMU();
  if ((fp = fopen("/ram/.score", "r"))) {
  #else
  if ((fp = fopen(DATA_PATH "/.score", "r"))) {
  #endif
    fscanf(fp, "%d", &(Root->HiScore));
    for (i = 0; i < 5; i ++)
      fscanf(fp, "%d %d %s",
	     &(Ranking[i]->Score),
	     &(Ranking[i]->Stage),
	     Ranking[i]->Name);
    fclose(fp);
  } else {
    Root->HiScore = 5000;
    for (i = 0; i < 4; i ++) {
      Ranking[i]->Score = 5000 - i * 1000;
      Ranking[i]->Stage = i == 3 ? 0 : 1;
      sprintf(Ranking[i]->Name, "hoge%d", i + 1);
    }
    Ranking[4]->Score = 1000;
    Ranking[4]->Stage = 0;
    sprintf(Ranking[4]->Name, "hoge5");
  }
}

/**********************
  񤭹
 **********************/
void WriteScore(void)
{
  FILE *fp;
  Uint16 i;

  #ifdef DREAMCAST
  if ((fp = fopen("/ram/.score", "w"))) {
  #else
  if ((fp = fopen(DATA_PATH "/.score", "w"))) {
  #endif
    fprintf(fp, "%d\n", Root->HiScore);
    for (i = 0; i < 5; i ++)
      fprintf(fp, "%d %d %s\n",
	      Ranking[i]->Score,
	      Ranking[i]->Stage,
	      Ranking[i]->Name);
    fclose(fp);
  }
  
  #ifdef DREAMCAST
  DC_SaveToVMU();
  #endif
}

#ifdef DREAMCAST

int DC_LoadFromVMU(void) {
    char* data;
    int filesize;
    //Name of the file to open
    file_t fd;
    if ((fd = fs_open("/vmu/a1/saryarya", O_RDONLY)) == -1)
    {
        printf("error opening VMU A1, no found saryarya.\n");
        return -1;
    }
    filesize = fs_total(fd);
    data = (char*)malloc(filesize);

    //Go to the starting position of the data
    //Caution, vmu is composed by header (128) + 1 icon (512)
    //SEEK_SET (absolute position), SEEK_CUR (relative position)
    fs_seek(fd,128+512, SEEK_SET);
    fs_read(fd, data, filesize);

    // Save buffer into a RAM file
    if ((fd = fs_open("/ram/.score", O_WRONLY)) == -1)
    {
        printf("Can't create RAM file from VMU.\n");
        return -1;
    }
    fs_write(fd, data, filesize);
    fs_close(fd);

    // Free unused memory
    free(data);
	
    return 0;
}

int DC_SaveToVMU(void) {
    vmu_pkg_t pkg;
    uint8 *pkg_out;
    int pkg_size;
    file_t ft;
    //Temporal for reading the file
    file_t file;
    int data_size;
    char *datasave;
	
	// Open file and copy to buffer
    file = fs_open("/ram/.score", O_RDONLY);
    data_size = fs_total(file);
    datasave = (char *)malloc(data_size+1);
    fs_read(file, datasave, data_size);
    fs_close(file);
    fs_unlink("/ram/.score");

    //Make the package to the VMU.
    strcpy(pkg.desc_short, "saryarya");
    strcpy(pkg.desc_long, "SpaceAryarya HiScore");
    strcpy(pkg.app_id, "saryarya");
    pkg.icon_cnt = 1;
    memcpy((void *)&pkg.icon_pal[0],(void *)&vmu_icon_pal,32);
    pkg.icon_data = (const uint8*)&vmu_icon_img;
    pkg.icon_anim_speed = 0;
    pkg.eyecatch_type = VMUPKG_EC_NONE;
    pkg.data_len = data_size;
    pkg.data = (const uint8*) datasave;

    vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

    fs_unlink("/vmu/a1/saryarya");
    ft = fs_open("/vmu/a1/saryarya", O_WRONLY);
    if (!ft) {
        printf("error writing\n");
        return -1;
    }
    fs_write(ft, pkg_out, pkg_size);
    fs_close(ft);

    // Free unused memory
    free(pkg_out);
    free(datasave);
	
	return 0;
}
#endif
