/*
**  Geki4
**  Copyright (C) 2001, kacchan
**  E-M@il address   fc3srx@mwnet.or.jp
**  Homepage address http://www2.mwnet.or.jp/~fc3srx7
*/
#ifndef _GEKI4_H_
#define _GEKI4_H_

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <KXL.h>

/** ե졼졼 **/
#define FRAME_RATE 40

/**  **/
#define KeyUp    KXL_KEY_Up
#define KeyDown  KXL_KEY_Down
#define KeyRight KXL_KEY_Right
#define KeyLeft  KXL_KEY_Left
#define KeyShot  KXL_KEY_z
#define KeyPause KXL_KEY_s

/** ޥ **/
#define KNone      0
#define KUp        (1L << 0)
#define KDown      (1L << 1)
#define KRight     (1L << 2)
#define KLeft      (1L << 3)
#define KShot      (1L << 4)
#define KPause     (1L << 5)

#define KUpMask    ~KUp
#define KDownMask  ~KDown
#define KRightMask ~KRight
#define KLeftMask  ~KLeft
#define KShotMask  ~KShot
#define KPauseMask ~KPause

/** 饯μ̻**/
#define AttrNone     0
#define AttrMy       (1L << 0)
#define AttrMShot    (1L << 1)
#define AttrEnemy    (1L << 2)
#define AttrEShot    (1L << 3)

/** ɥ **/
#define DRAW_WIDTH   500
#define DRAW_HEIGHT  300
#define FREE_AREA    60
#define PICT_WIDTH   (DRAW_WIDTH + FREE_AREA * 2)
#define PICT_HEIGHT  (DRAW_HEIGHT + FREE_AREA * 2)
#define AREA_LX      FREE_AREA
#define AREA_LY      FREE_AREA
#define AREA_RX      (PICT_WIDTH - FREE_AREA)
#define AREA_RY      (PICT_HEIGHT - FREE_AREA)
#define DRAW_LEFT    -DRAW_WIDTH / 2
#define DRAW_RIGHT   DRAW_WIDTH / 2
#define DRAW_TOP     -DRAW_HEIGHT / 2
#define DRAW_BOTTOM  DRAW_HEIGHT / 2
#define ADD_X        AREA_LX + DRAW_RIGHT
#define ADD_Y        AREA_LY + DRAW_BOTTOM
#define CHECK_PER    0.05
#define CHECK_MAX    4
#define BASE_Z       15
#define MAX_Z        60
#define STAGE_MAX    2

/** Ƽ **/
#define MAX_YOUR    80 /** Ũ&Ũ **/
#define MAX_MY      16  /** ץ쥤䡼&ץ쥤䡼 **/

/**  **/
#define SE_BOMB     0
#define SE_HIT      1
#define SE_FIRE     2
#define SE_DIE      3

#define SE_BGM1     0
#define SE_BOSS     1

/** ᥤư **/
typedef enum {
  MainOpening,
  MainGame,
  MainClear,
  MainGameOver,
  MainEnding,
  MainPause
} MainEnum;

/*ư*/
typedef enum {
  RcHitNone,
  RcHitDel,
  RcHitBomb,
  RcHitBoss
} RcHitEnum;

/** ԥå **/
typedef struct {
  KXL_Image *Image;
  Sint16 x[4], y[4];  /** 0:left&top,   1:right&top,
                         2:left&bottom,3:right&bottom **/
  Uint16 AddX, AddY; /** 濴ɸβû **/   
} PixData;

/** 饯ǡ **/
typedef struct {
  Bool    Active;           /**  **/
  Uint16  Attr;             /** ̻ **/
  Uint16  Target;           /** å **/
  Sint16  Hp;               /** ѵ **/
  Sint16  Cnt1, Cnt2, Cnt3; /**  **/
  Uint32  Score;            /**  **/
  Sint16  X, Y, Z;          /** ץ饤Ⱥɸ **/
  Sint16  AddX, AddY, AddZ; /** ץ饤Ȱư̲û **/
  Uint8   FrameNo;          /** ե졼No. **/
  PixData **Spr;            /** ᡼ **/
} CharacterData;

/** ѥ饯ǡ **/
typedef struct {
  CharacterData Chr;
  void (*Draw)(CharacterData *my);
  RcHitEnum (*Move)(CharacterData *my);
  RcHitEnum (*Hit)(CharacterData *my, CharacterData *your);
} CharacterObject;

/**  **/
typedef struct {
  MainEnum MainFlag;      /** ᥤե饰 **/
  Uint16   Key;           /**  **/
  Uint8    MyNo;          /** ʬ¦Υ饯 **/
  Uint8    YourNo;        /** Ũ¦Υ饯 **/
  Sint16   Cnt;           /** ѥ **/
  Bool     WaitFlag;      /** ݡե饰 **/
  CharacterObject **My;   /** ʬ¦Υ饯 **/
  CharacterObject **Your; /** Ũ¦Υ饯 **/
  Uint32   Score;         /**  **/
  Uint32   HiScore;       /** ϥ **/
  Uint8    Left;          /** ĵ **/
  Uint8    Stage;         /** ơ **/
  Uint8    StageMax;      /** Ũиѥ **/
  Uint16   EnemyCnt;      /** Ũи **/
} RootData;

/*󥭥*/
typedef struct {
  Uint32 Score;
  Uint8  Stage;
  Uint8  Name[16];
} RankingData;

/*ơǡ*/
typedef struct {
  Uint16 Time;         /* Ũи */
  Uint8  CreateNo;     /* ŨNo. */
  Uint8  Max;          /* Ũи */
  Uint16 Step;         /* Ũиֳ */
  Uint16 StepTime;
  Bool Flag;
} StageData;

#endif
