/***********************************************************************
  Geki4
 ***********************************************************************/
#include "geki4.h"
#define _EXTERN_DEF_
#include "extern.h"

#ifdef DREAMCAST
	#include <kos.h>
	#include "pal.h" // 50/60Hz Selector

	extern uint8 romdisk[];
	KOS_INIT_FLAGS(INIT_DEFAULT);
	KOS_INIT_ROMDISK(romdisk);

	maple_device_t *mcont;
	cont_state_t *cond;
#endif


//DC: Moved common code into a function
Bool Status(KXL_Rect rect)
{
	/** ᥤե饰å **/
    switch (Root->MainFlag) {
    case MainPause: /*ݡ*/
      Root->MainFlag = (Root->Key & KShot) ? MainGame : MainPause;
      break;
    case MainOpening: /*ץ˥*/
      if (Opening() == True)
        return True;
      break;
    case MainGame: /*ץ쥤*/
      Game();
      break;
    case MainClear: /*ꥢ*/
    case MainGameOver: /*४С*/
      Game();
      ClearAndGameOver();
      break;
    case MainEnding:
      return True;
      break;
    }
    Root->Cnt ++;
    KXL_UpDate(rect);
	KXL_UpdateMusic();
	return False;
}

/****************************
  ᥤ롼(޳)
 ****************************/
void MainLoop(void)
{
  KXL_Rect rect={AREA_LX, AREA_LY, DRAW_WIDTH, DRAW_HEIGHT};

  #ifdef DREAMCAST
	mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	if (!mcont) return;
  #endif
  
  while (1) {
    /*޳Ԥ*/
    if (KXL_GetTimer() == False)
      continue;
    KXL_ResetTimer();
	
	//DC: Replace the next chunk of code with our KOS Maple code :)
	#ifdef DREAMCAST
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (cond) 
		{
			Root->Key = KNone;
			
			//Axis are now 0-based position in new Maple code!
			if ((cond->buttons & CONT_DPAD_UP) || (cond->joyy < 0))
				Root->Key |= KUp;
			if ((cond->buttons & CONT_DPAD_DOWN) || (cond->joyy > 0))
				Root->Key |= KDown;
			if ((cond->buttons & CONT_DPAD_LEFT) || (cond->joyx < 0))
				Root->Key |= KLeft;
			if ((cond->buttons & CONT_DPAD_RIGHT) || (cond->joyx > 0))
				Root->Key |= KRight;

			if (cond->buttons & CONT_A)
				Root->Key |= KShot;
			if (cond->buttons & CONT_X)
				Root->Key |= KPause;

			//Just add an option to return to Main Menu :-)
			if (cond->buttons & CONT_START) {
			  if (Root->MainFlag != MainOpening) {
				KXL_EndMusic();
				DeleteStage();
				Root->MainFlag = MainOpening;
				Root->Cnt = 0;
			  }
			}
			
		}
		if (Status(rect) == True) return;
	#else
		 /*إ٥Ƚ*/
		while (KXL_CheckEvents()) {
		  switch (KXL_GetEvents()) {
		  case KXL_EVENT_KEY_PRESS: /**/
			switch (KXL_GetKey()) {
			case KeyShot:  Root->Key |= KShot;  break;
			case KeyLeft:  Root->Key |= KLeft;  break;
			case KeyRight: Root->Key |= KRight; break;
			case KeyUp:    Root->Key |= KUp;    break;
			case KeyDown:  Root->Key |= KDown;  break;
			case KeyPause: Root->Key |= KPause; break;
			default:                            break;
			}
			break;
		  case KXL_EVENT_KEY_RELEASE: /*Υ*/
			switch (KXL_GetKey()) {
			case KeyShot:  Root->Key &= KShotMask;  break;
			case KeyLeft:  Root->Key &= KLeftMask;  break;
			case KeyRight: Root->Key &= KRightMask; break;
			case KeyUp:    Root->Key &= KUpMask;    break;
			case KeyDown:  Root->Key &= KDownMask;  break;
			case KeyPause: Root->Key &= KPauseMask; break;
			default:                                break;
			}
			break;
		  default:
			break;
		  }
		}
		if (Status(rect) == True) return;
	#endif
  }
}

/****************************
  롼ΰ&
 ****************************/
void CreateRoot(void)
{
  Uint16 i;

  /** 롼ΰ **/
  Root = (RootData *)KXL_Malloc(sizeof(RootData));
  Root->My = (CharacterObject **)KXL_Malloc(sizeof(CharacterObject *) * MAX_MY);
  for (i = 0; i < MAX_MY; i ++) {
    Root->My[i] = (CharacterObject *)KXL_Malloc(sizeof(CharacterObject));
    Root->My[i]->Chr.Active = False;
  }
  Root->Your = (CharacterObject **)KXL_Malloc(sizeof(CharacterObject *) * MAX_YOUR);
  for (i = 0; i < MAX_YOUR; i ++) {
    Root->Your[i] = (CharacterObject *)KXL_Malloc(sizeof(CharacterObject));
    Root->Your[i]->Chr.Active = False;
  }
  Ranking = (RankingData **)KXL_Malloc(sizeof(RankingData *) * 5);
  for (i = 0; i < 5; i ++)
    Ranking[i] = (RankingData *)KXL_Malloc(sizeof(RankingData));
  /** ɥ **/
  KXL_CreateWindow(DRAW_WIDTH,
                   DRAW_HEIGHT,
                   TITLE,
                   KXL_EVENT_KEY_PRESS_MASK |
                   KXL_EVENT_KEY_RELEASE_MASK);
  KXL_ReSizeFrame(PICT_WIDTH, PICT_HEIGHT);
  /** 롼Ƚ **/
  ReadScore();
  Root->MainFlag = MainOpening;
  Root->Key = KNone;
  Root->Cnt = 0;
  Root->WaitFlag = True;
}

/****************************
  롼ΰ
 ****************************/
void DeleteRoot(void)
{
  Uint16 i;
  
  KXL_DeleteWindow();
  for (i = 0; i < MAX_MY; i ++)
    KXL_Free(Root->My[i]);
  for (i = 0; i < MAX_YOUR; i ++)
    KXL_Free(Root->Your[i]);
  KXL_Free(Root);
}

#ifndef DREAMCAST
/****************************
      ץ
 ****************************/
void options(int argc, char **argv)
{
  Uint16 i;

  fprintf(stderr, "url   : http://www2.mwnet.or.jp/~fc3srx7\n");
  fprintf(stderr, "email : fc3srx7@mwnet.or.jp\n\n");
  for (i = 1; i < argc; i ++) {
    if (!strcmp(argv[i], "-h") || !strcmp(argv[i], "--help")) {
      fprintf(stderr, "\nUsage: spacearyarya [--display display] [--version] [--help]\n");
      fprintf(stderr, "--display display : Use display as the target display\n");
      fprintf(stderr, "--version         : Show version number and exit\n");
      fprintf(stderr, "--help            : Show this message\n");
      exit(1);
    }
  }
  fprintf(stderr, "\"spacearyarya --help\" for command line parameters\n");
  for (i = 1; i < argc; i ++) {
    if (!strcmp(argv[i], "--display")) {
      fprintf(stderr, "Using display: %s\n", argv[i + 1]);
      KXL_DisplayName(argv[i + 1]);
    }
    if (!strcmp(argv[i], "--version")) {
      fprintf(stderr, "Version is " VERSION "\n");
      exit(1);
    }
  }
}
#endif
  
/****************************
      ᥤ롼
 ****************************/
int main(int argc, char **argv)
{
  Uint8 *sname[]={
    WAV_PATH "/bomb.wav",
    WAV_PATH "/hit.wav",
    WAV_PATH "/fire.wav",
    WAV_PATH "/die.wav",
    ""};
	
  Uint8 *mname[]={
    WAV_PATH "/bgm1.wav",
    WAV_PATH "/boss.wav",
    ""};
  
  #ifndef DREAMCAST
	 options(argc, argv);
  #else
	  //Init video with PM_RGB565 mode
	  int dc_region, ct;
	  
	  dc_region = flashrom_get_region();
	  ct = vid_check_cable();
	 
	  /* Prompt the user for whether to run in PAL50 or PAL60 if the flashrom says
		the Dreamcast is European and a VGA Box is not hooked up. */
	  if(dc_region == FLASHROM_REGION_EUROPE && ct != CT_VGA) {
		if(pal_menu()) {
			vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
		}
		else {
			vid_set_mode(DM_640x480_PAL_IL, PM_RGB565);
		}
	  }
	  else vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
	  
	  //Init the PVR system
	  pvr_init_defaults();
  #endif
  
  srand(time(NULL));
  CreateRoot();
  CreatePixmap();
  KXL_InitSound(sname);
  KXL_InitMusic(mname);
  KXL_Timer(FRAME_RATE);
  //Enter Game
  MainLoop();
  //Leaving...
  KXL_EndMusic();
  KXL_EndSound();
  DeletePixmap();
  DeleteRoot();
  
  #ifdef DREAMCAST
	  pvr_shutdown();
  #endif
  
  return 0;
}
