//====================================================
// Grande
// Copyright (C) 2002, kacchan
// E-M@il address   fc3srx@mwnet.or.jp
// Homepage address http://www2.mwnet.or.jp/~fc3srx7
//====================================================

// More PVR business, this case renders a custom font like a Sprite :)

#include <kos.h>

#include "font.h"
#include "pcfont.h"

#define FONT_WIDTH 8
#define FONT_HEIGHT 16

pvr_ptr_t font_texture;

//xs, ys = xscale, yscale
static void draw_char(float x1, float y1, float z1, float xs, float ys, float a, float r,
                float g, float b, int c) {
        
        pvr_vertex_t vert;
		
        int ix, iy;
        float u1, v1, u2, v2;

        if (c == ' ') 
                return;
        
        ix = (c % 32) * 8;
        iy = (c / 32) * 16;
        u1 = ix * 1.0f / 256.0f;
        v1 = iy * 1.0f / 256.0f;
        u2 = (ix+8) * 1.0f / 256.0f;
        v2 = (iy+16) * 1.0f / 256.0f;

		vert.flags =  PVR_CMD_VERTEX;
		
        vert.x = x1;
        vert.y = y1 + FONT_HEIGHT;
        vert.z = z1;   
        vert.u = u1;
        vert.v = v2;
		
		//PVR_PACK_COLOR: Values between 0.0f and 1.0f for Alpha, Red, Green, Blue
		vert.argb = PVR_PACK_COLOR(a, r / 255, g / 255, b / 255);
		vert.oargb = 0.0f;

		//Scale chars
		vert.x*=xs;
		vert.y*=ys;

		pvr_prim(&vert, sizeof(vert));

        vert.x = x1;
        vert.y = y1;
        vert.u = u1;
        vert.v = v1;

		//Scale chars
		vert.x*=xs;
		vert.y*=ys;

		pvr_prim(&vert, sizeof(vert));

        vert.x = x1 + FONT_WIDTH;
        vert.y = y1 + FONT_HEIGHT;
        vert.u = u2;
        vert.v = v2;

		vert.x*=xs;
		vert.y*=ys;

		pvr_prim(&vert, sizeof(vert));

		vert.flags = PVR_CMD_VERTEX_EOL;
		
        vert.x = x1 + FONT_WIDTH;  
        vert.y = y1;
        vert.u = u2;
        vert.v = v1;

		vert.x*=xs;
		vert.y*=ys;

		pvr_prim(&vert, sizeof(vert));
}

void font_deinittxr() {
	if(font_texture) {
		free(font_texture);
	}
	font_texture=0;
}


int atexit(void (*function)(void));
void font_inittxr() {
        uint16 *vram;
        int x, y;

        pcfont_set(fontdata, 16);

        //Prepare VRAM to store every Font Char.
		font_texture = pvr_mem_malloc(256*256*2);
		vram = (uint16 *)font_texture;

        for (y = 0; y < 256; y++)
                for (x = 0; x < 256; x++)
                        vram[y*256+x]=0;

        for (y = 0; y < 8; y++)
                for (x = 0; x < 32; x++)
                        pcfont_char(&vram[y*256*16+x*8], 256, 0xffff, y*32 + x);

	atexit(font_deinittxr);
}

//xs, ys = xscale, yscale
void draw_string(float x, float y, float z, float xs, float ys, float a, float r, float g,
                float b, char *str, int len) {
        int i;
		pvr_poly_hdr_t poly;
		pvr_poly_cxt_t cxt;

		if(!font_texture) {
			font_inittxr();
		}

		/* Setup a polygon header for the texture. Use "font_texture" address.*/
		pvr_poly_cxt_txr(&cxt, PVR_LIST_TR_POLY, PVR_TXRFMT_ARGB4444|PVR_TXRFMT_NONTWIDDLED, 256, 256, font_texture, PVR_FILTER_BILINEAR);
		pvr_poly_compile(&poly, &cxt);
		pvr_prim(&poly, sizeof(poly));
		
		//Draw each character of the string
		for (i = 0; i < len; i++) {
                draw_char(x, y, z, xs, ys, a, r, g, b, str[i]);
                x += FONT_WIDTH;
        }
}
