#include <kos.h>
#include <time.h>
#include "pal.h" // 50/60Hz Selector

#include "grande.h"
#define _EXTERN_DEF_
#include "extern.h"

//DC Romdisk Init
extern uint8 romdisk[];
KOS_INIT_FLAGS(INIT_DEFAULT);
KOS_INIT_ROMDISK(romdisk);

maple_device_t *mcont;
cont_state_t *cond;

void MainLoop(void)
{
  KXL_Rect rect = {UP_TOP, UP_LEFT, WIDTH, HEIGHT};
  MainEnum bak = -1;
  mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
  if (!mcont) return;
  
  while (1) {
    if (KXL_GetTimer() == False) continue;
    KXL_ResetTimer();
    {
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (cond) 
		{
			Root->Key = KNone;

			//Axis are now 0-based position in new Maple code!
			if ((cond->buttons & CONT_DPAD_UP) || (cond->joyy < 0))
				Root->Key |= KUp;
			if ((cond->buttons & CONT_DPAD_DOWN) || (cond->joyy > 0))
				Root->Key |= KDown;
			if ((cond->buttons & CONT_DPAD_LEFT) || (cond->joyx < 0))
				Root->Key |= KLeft;
			if ((cond->buttons & CONT_DPAD_RIGHT) || (cond->joyx > 0))
				Root->Key |= KRight;

			if (cond->buttons & CONT_A)
				Root->Key |= KShot;
			if (cond->buttons & CONT_B)
				Root->Key |= KSShot;
			if (cond->buttons & CONT_X)
				Root->Key |= KCShot;
			if (cond->buttons & CONT_Y)
				Root->Key |= KPause;

			if (cond->buttons & CONT_START) {
			  if (Root->MainFlag != MainOpening) {
				UnLoadStageData();
				Root->MainFlag = MainOpening;
				Root->Cnt = 0;
			  }
			}
		}
    }

    bak = Root->MainFlag;

    switch (Root->MainFlag) {
    case MainOpening:
      if (Opening() == True) return;
      break;
    case MainStart:
      Start();
      break;
    case MainGame:
      Game(True);
      if (Root->Key & KPause) Root->MainFlag = MainPause;
      break;
    case MainPause:
      Game(False);
      Root->MainFlag = (Root->Key & KShot) ? MainGame : MainPause;
      break;
    case MainClear:
      Game(True);
      ClearAndGameOver();
      break;
    case MainGameOver:
      Game(True);
      ClearAndGameOver();
      break;
	case MainKXL:
	  break;
    case MainEnding:
      break;
    }
    if (bak != Root->MainFlag) Root->Cnt = 0;
    else                       Root->Cnt ++;
    KXL_UpDate(rect);
  }
}

void CreateRoot(void)
{
  Root = (RootData *)KXL_Malloc(sizeof(RootData));
  Root->My = (CharacterObject *)KXL_Malloc(sizeof(CharacterObject) * MAX_MY);
  Root->Your = (CharacterObject *)KXL_Malloc(sizeof(CharacterObject) * MAX_YOUR);
  Ranking = (RankingData *)KXL_Malloc(sizeof(RankingData) * 5);
  KXL_CreateWindow(WIDTH, HEIGHT,
                   TITLE,
                   KXL_EVENT_KEY_PRESS_MASK |
                   KXL_EVENT_KEY_RELEASE_MASK);
  KXL_ReSizeFrame(PIC_WIDTH, PIC_HEIGHT);
  Root->MainFlag = MainOpening;
  ReadScore();
  Root->Key = KNone;
}

void DeleteRoot(void)
{
  KXL_DeleteWindow();
  KXL_Free(Root->My);
  KXL_Free(Root->Your);
  KXL_Free(Root);
  KXL_Free(Ranking);
}

int main(int argc, char **argv)
{
  printf("Starting...\n");
  
  Uint8 *sname[] = {
    WAV_PATH "/pow.wav",
    WAV_PATH "/bomb.wav",
    WAV_PATH "/shot.wav",
    WAV_PATH "/go.wav",
    WAV_PATH "/mbomb.wav",
    ""
  };

  /*Init video with PM_RGB565 mode
  * PM_RGB565: 2 bytes per pixel
  * PM_RGB888: 3-4 bytes per pixel
  */
  int dc_region, ct;
  
  dc_region = flashrom_get_region();
  ct = vid_check_cable();
 
  /* Prompt the user for whether to run in PAL50 or PAL60 if the flashrom says
	the Dreamcast is European and a VGA Box is not hooked up. */
  if(dc_region == FLASHROM_REGION_EUROPE && ct != CT_VGA) {
	if(pal_menu()) {
		vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
	}
	else {
		vid_set_mode(DM_640x480_PAL_IL, PM_RGB565);
	}
  }
  else vid_set_mode(DM_640x480_NTSC_IL, PM_RGB565);
  
  //Init the PVR system
  pvr_init_defaults();
  
  srand(time(NULL));

  CreateRoot();
  CreateImage();
  KXL_InitSound(sname);
  KXL_Timer(FRAME_RATE);
  //Enter Game
  MainLoop();
  //Leaving...
  KXL_EndSound();
  DeleteImage();
  DeleteRoot();
  
  //Shutdown PVR system
  pvr_shutdown();
  return 0;
}
