//====================================================
// Grande
// Copyright (C) 2002, kacchan
// E-M@il address   fc3srx@mwnet.or.jp
// Homepage address http://www2.mwnet.or.jp/~fc3srx7
//====================================================
#include "grande.h"
#include "extern.h"

//========================================
// ϰ
//========================================
void SetPer(PixData *my, float per)
{
  my->r.Width  = (Uint16)((float)my->img->Width  * per + 0.5);
  my->r.Height = (Uint16)((float)my->img->Height * per + 0.5);
  my->r.Left   = (my->img->Width  - my->r.Width)  / 2;
  my->r.Top    = (my->img->Height - my->r.Height) / 2;
}
//========================================
// ᡼ʬ
//========================================
Sprite *LoadImageSplit(Uint8 *fname, Uint8 blend, Uint16 max, float per)
{
  Uint8 filename[64];
  Uint16 w, h, i;
  KXL_Image *tmp;
  Sprite *new;

  // bmpեɤ߹
  sprintf(filename, BMP_PATH "/%s.bmp", fname);
  tmp = KXL_LoadBitmap(filename, blend);
  w = tmp->Width / max;
  h = tmp->Height;
  // ᡼ʬ
  new = (Sprite *)KXL_Malloc(sizeof(Sprite));
  new->max = max;
  new->data = (PixData *)KXL_Malloc(sizeof(PixData) * max);
  for (i = 0; i < max; i ++) {
    new->data[i].img = KXL_CopyImageImm(tmp, i * w, 0, w, h);
    SetPer(&(new->data[i]), per);
  }
  // ɤ߹Image
  KXL_DeleteImage(tmp);
  return new;
}
//========================================
// ᡼
//========================================
void LoadImage(PixData *new, Uint8 *fname, Uint8 blend, float per)
{
  Uint8 filename[64];

  // bmpեɤ߹
  sprintf(filename, BMP_PATH "/%s.bmp", fname);
  new = (PixData *)KXL_Malloc(sizeof(PixData));
  new->img = KXL_LoadBitmap(filename, blend);
  SetPer(new, per);
}
//========================================
// ʣեΥ᡼
//========================================
Sprite *LoadImages(Uint8 *fname, Uint8 blend, Uint16 max, float per)
{
  Sprite *new;
  Uint8 filename[64];
  Uint16 i;

  new = (Sprite *)KXL_Malloc(sizeof(Sprite));
  new->max = max;
  new->data = (PixData *)KXL_Malloc(sizeof(PixData) * max);
  for (i = 0; i < max; i ++) {
    sprintf(filename, "%s%d", fname, i + 1);
    LoadImage(&(new->data[i]), filename, blend, per);
  }
  return new;
}
//========================================
// ᡼
//========================================
void UnLoadImages(Sprite *my)
{
  while (my->max)
    KXL_DeleteImage(my->data[-- my->max].img);
  KXL_Free(my->data);
  KXL_Free(my);
}
//========================================
// ᡼
//========================================
void CreateImage(void)
{
  // ʬ
  PixMy         = LoadImageSplit("my", 0, 5 * 2, 0.4);
  PixMyLaser    = LoadImageSplit("mlaser", 0, 2, CHECK_PER);
  PixMySub00    = LoadImageSplit("msub00", 0, 8, CHECK_PER);
  PixMySub01    = LoadImageSplit("msub01", 0, 8, CHECK_PER);
  PixMySub02    = LoadImageSplit("msub02", 0, 8, CHECK_PER);
  PixMySub03    = LoadImageSplit("msub03", 0, 8, CHECK_PER);
  PixMySub1     = LoadImageSplit("msub1", 0, 5, CHECK_PER);
  PixMySub20    = LoadImageSplit("msub20", 0, 3, CHECK_PER);
  PixMySub21    = LoadImageSplit("msub21", 0, 3, CHECK_PER);
  PixMySub22    = LoadImageSplit("msub22", 0, 3, CHECK_PER);
  PixMySub23    = LoadImageSplit("msub23", 0, 3, CHECK_PER);
  PixMySub30    = LoadImageSplit("msub30", 0, 5, CHECK_PER);
  PixMySub3     = LoadImageSplit("msub3", 0, 13, CHECK_PER);
  PixMyCShot    = LoadImageSplit("cshot", 0, 4, CHECK_PER);
  PixHit        = LoadImageSplit("hit", 0, 8, CHECK_PER);
  PixItem       = LoadImageSplit("item", 0, 6 * 2, 1);

  // Ũ
  PixEShot1     = LoadImageSplit("eshot1", 0, 1,  CHECK_PER);
  PixEShot2     = LoadImageSplit("eshot2", 0, 6,  CHECK_PER);
  PixEShot3     = LoadImageSplit("eshot3", 0, 36,  0.6);
  PixRoll       = LoadImageSplit("roll", 0, 6 * 2, CHECK_PER);
  PixKuru       = LoadImageSplit("kuru", 0, 12 * 2, CHECK_PER);
  PixHoudai     = LoadImageSplit("houdai", 0, 6, CHECK_PER);
  PixUturn      = LoadImageSplit("uturn", 0, 10 * 2, CHECK_PER);
  PixOpenH      = LoadImageSplit("openh", 0, 7, CHECK_PER);
  PixFly1       = LoadImageSplit("fly1", 0, 2 * 2, CHECK_PER);
  PixFly2       = LoadImageSplit("fly2", 0, 12 * 2, CHECK_PER);
  PixHory       = LoadImageSplit("hory", 0, 4 * 2, CHECK_PER);
  PixBound      = LoadImageSplit("bound", 0, 6 * 2, CHECK_PER);
  PixEgg        = LoadImageSplit("egg", 0, 3 * 2, CHECK_PER);
  PixBohu       = LoadImageSplit("bohu", 0, 3 * 2, CHECK_PER);
  PixFBoard     = LoadImageSplit("fboard", 0, 6 * 2, CHECK_PER);
  PixMany       = LoadImageSplit("many", 0, 12 * 2, CHECK_PER);
  PixMBoss      = LoadImageSplit("mboss", 0, 1 * 2, CHECK_PER);

  // ¾
  PixBomb1      = LoadImageSplit("bomb1", 0, 13, CHECK_PER);
  PixCrash1     = LoadImageSplit("crash1", 0, 6, CHECK_PER);
  PixCrash2     = LoadImageSplit("crash2", 0, 6, CHECK_PER);
  PixChargeBack = KXL_LoadBitmap(BMP_PATH "/chargeback.bmp", 0);
  PixCharge     = KXL_LoadBitmap(BMP_PATH "/charge.bmp", 0);
}
//========================================
// ᡼
//========================================
void DeleteImage(void)
{
  // ʬ
  UnLoadImages(PixMy);
  UnLoadImages(PixMyLaser);
  UnLoadImages(PixMySub00);
  UnLoadImages(PixMySub01);
  UnLoadImages(PixMySub02);
  UnLoadImages(PixMySub03);
  UnLoadImages(PixMySub1);
  UnLoadImages(PixMySub20);
  UnLoadImages(PixMySub21);
  UnLoadImages(PixMySub22);
  UnLoadImages(PixMySub23);
  UnLoadImages(PixMySub30);
  UnLoadImages(PixMySub3);
  UnLoadImages(PixMyCShot);
  UnLoadImages(PixItem);
  UnLoadImages(PixHit);

  // Ũ
  UnLoadImages(PixEShot1);
  UnLoadImages(PixEShot2);
  UnLoadImages(PixEShot3);
  UnLoadImages(PixRoll);
  UnLoadImages(PixKuru);
  UnLoadImages(PixHoudai);
  UnLoadImages(PixUturn);
  UnLoadImages(PixOpenH);
  UnLoadImages(PixFly1);
  UnLoadImages(PixFly2);
  UnLoadImages(PixHory);
  UnLoadImages(PixBound);
  UnLoadImages(PixEgg);
  UnLoadImages(PixBohu);
  UnLoadImages(PixFBoard);
  UnLoadImages(PixMany);
  UnLoadImages(PixMBoss);

  // ¾
  UnLoadImages(PixBomb1);
  UnLoadImages(PixCrash1);
  UnLoadImages(PixCrash2);
  KXL_DeleteImage(PixChargeBack);
  KXL_DeleteImage(PixCharge);
}

//========================================
// ơǡɤ߹
//========================================
void LoadStageData(void)
{
  FILE *fp;
  Uint8 buff[256];
  Uint8 bm[4] = {11, 20, 10, 13};
  Uint8 bs[4] = {1, 1 * 2, 1 * 2, 5};
  Uint8 i;

  // طʥ᡼
  sprintf(buff, "back%d", Root->Stage + 1);
  PixBack = LoadImageSplit(buff, 255, bm[Root->Stage], CHECK_PER);
  // ܥ᡼
  sprintf(buff, "boss%d", Root->Stage + 1);
  PixBoss = LoadImageSplit(buff, 0, bs[Root->Stage], CHECK_PER);
  if (Root->Stage == 1)
    PixBossSub = LoadImageSplit("boss2houdai", 0, 12, CHECK_PER);
  else
    PixBossSub = 0;
  // طʥǡɹ
  sprintf(buff, DATA_PATH "/back%d.dat", Root->Stage + 1);
  fp = fopen(buff, "r");
  Root->BackMax  = 0;
  Root->BackLine = 0;
  Root->BackAdd  = 0;
  while (fgets(buff, 255, fp)) {
    if (buff[0] == ';' || buff[0] == '\n') continue;
    // ΰݤ
    if (!Root->BackMax)
      Back = (Uint8 **)KXL_Malloc(sizeof(Uint8 *));
    else
      Back = (Uint8 **)KXL_Realloc(Back, sizeof(Uint8 *) * (Root->BackMax + 1));
    Back[Root->BackMax] = (Uint8 *)KXL_Malloc(12);
    // ǡ
    for (i = 0; i < 12; i ++)
      Back[Root->BackMax][i] = buff[i] - 'a';
    Root->BackMax ++;
  }
  fclose(fp);
  
  // Ũиǡեɤ߹
  sprintf(buff, DATA_PATH "/stage%d.dat", Root->Stage + 1);
  fp = fopen(buff, "r");
  Root->StageMax = 0;
  Root->EnemyCnt = 0;
  while(fgets(buff, 255, fp)) {
    if (buff[0] == ';' || buff[0] == '\n') continue;
    if (!Root->StageMax)
      StageDatas = (StageData *)KXL_Malloc(sizeof(StageData));
    else
      StageDatas = (StageData *)KXL_Realloc(StageDatas, sizeof(StageData) * (Root->StageMax + 1));

    {
      int cnt=0;
      char *str=(char *)buff;
      Uint8 *st[6];

      for (cnt=0; cnt<6; ) {
        if ((st[cnt] = strsep(&str, " \t\n")) == NULL)
          break;
        if (*st[cnt] != '\0')
          cnt++;
      }

      if(cnt==6) {
        StageDatas[Root->StageMax].Time=atoi(st[0]);
        StageDatas[Root->StageMax].CreateNo=atoi(st[1]);
        StageDatas[Root->StageMax].Max=atoi(st[2]);
        StageDatas[Root->StageMax].Step=atoi(st[3]);
        strcpy(StageDatas[Root->StageMax].X,st[4]);
        strcpy(StageDatas[Root->StageMax].Y,st[5]);
//        printf("Enemy T:%i N:%i M:%i S:%i X:%i Y:%i\r\n",atoi(st[0]),
//                atoi(st[1]),atoi(st[2]),atoi(st[3]),atoi(st[4]),atoi(st[5]));
      }
    }

    StageDatas[Root->StageMax].Flag = False;
    StageDatas[Root->StageMax ++].StepTime = 0;
  }
  fclose(fp);
}
//========================================
// ơǡ
//========================================
void UnLoadStageData(void)
{
  // ᡼
  UnLoadImages(PixBack);
  UnLoadImages(PixBoss);
  if (PixBossSub)
    UnLoadImages(PixBossSub);
  // ơǡ
  if (Root->StageMax)
    KXL_Free(StageDatas);
  // طʥǡ
  if (Root->BackMax) {
    while (Root->BackMax)
      KXL_Free(Back[-- Root->BackMax]);
    KXL_Free(Back);
  }
}
