//====================================================
// Grande
// Copyright (C) 2002, kacchan
// E-M@il address   fc3srx@mwnet.or.jp
// Homepage address http://www2.mwnet.or.jp/~fc3srx7
//====================================================
#include "grande.h"
#include "extern.h"

#define SUB3MAX 32
typedef struct {
  Uint16 x, y;
} Sub3XY;
typedef struct {
  Bool Active;
  Sub3XY xy[4];
} Sub3Data;
Sub3Data sub3data[SUB3MAX];

//========================================
// ʬ
//========================================
void CreateShip(void) {
  Uint16 i;

  for (i = 0; i < MAX_YOUR; i ++)
    Root->Your[i].Chr.Active = False;
  for (i = 0; i < MAX_MY; i ++)
    Root->My[i].Chr.Active = False;
  for (i = 0; i < SUB3MAX; i ++)
    sub3data[i].Active = False;
  Cchr.Attr    = AttrMy;
  Cchr.Target  = AttrItem;
  Cchr.Cnt1    = 2000 / FRAME_RATE;
  Cchr.Cnt2    = 0;
  Cchr.Cnt3    = 0;
  Cchr.Spr     = PixMy;
  Cchr.X       = UP_LEFT + WIDTH / 2 - Cchr.Spr->data[0].img->Width / 2;
  Cchr.Y       = UP_BOTTOM - Cchr.Spr->data[0].img->Height;
  Cchr.Active  = True;
  Cchr.FrameNo = 2;
  Cchr.Power   = 100;
  Root->My[MY_NO].Chr  = Cchr;
  Root->My[MY_NO].Move = MoveShip;
  Root->My[MY_NO].Draw = DrawImageFrame;
  Root->My[MY_NO].Hit  = HitShip;
  if (Root->Stage == 0) {
    Root->OneUp = 5000;
    Root->MainLevel = 0;
    Root->SubNo     = 0;
    Root->SubLevel  = 0;
  }
  Root->ChargeCnt = 0;
}
//========================================
// ư
//========================================
RcHitEnum MoveShip(CharacterData *my)
{
  static int mcnt = 0;
  static Uint8 frn[11] = {0,1,1,1,1,2,3,3,3,3,4};
  Uint8 d;
  
  my->AddX = my->AddY = 0;
  if (Root->Key & KRight) { // ˰ư
    my->AddX = 6;
    if (mcnt < 5) mcnt ++; // Τ򱦤˷
  }
  if (Root->Key & KLeft) { // ˰ư
    my->AddX = -6;
    if (mcnt > -5) mcnt --; // Τ򺸤˷
  }
  if (Root->Key & KUp) my->AddY = -6; // ˰ư
  if (Root->Key & KDown) my->AddY = 6; // ˰ư
  if ((Root->Key & (KLeft | KRight)) == 0) mcnt += -SGN(mcnt); // Τ򸵤᤹
  my->FrameNo = frn[5 + mcnt]; // ե졼ֹ
  if (my->Cnt1 > 0) { // ̵Ũ
    d = (my->Cnt1 > 20) ? 2 : 4;
    if (my->Cnt1 % d == 0)
      Root->My[MY_NO].Draw = ClearImage;
    else
      Root->My[MY_NO].Draw = DrawImageFrame;
    if (-- my->Cnt1 == 0) { // ̵Ũλ
      Root->My[MY_NO].Chr.Target = AttrEnemy | AttrEShot | AttrEBomb | AttrItem;
      Root->My[MY_NO].Chr.Attr |= AttrShadow;
    }
  }
  // ưϰϥå
  my->X += my->AddX;
  my->Y += my->AddY;
  if (my->X < UP_LEFT)
    my->X = UP_LEFT;
  else if (my->X > UP_RIGHT - my->Spr->data[0].img->Width)
    my->X = UP_RIGHT - my->Spr->data[0].img->Width;
  if (my->Y < UP_TOP)
    my->Y = UP_TOP;
  else if (my->Y > UP_BOTTOM - my->Spr->data[0].img->Height)
    my->Y = UP_BOTTOM - my->Spr->data[0].img->Height;
  // ᥤ󥷥å
  if ((Root->Key & KShot) && my->Cnt2 == 0)
    SetMain(my);
  if (my->Cnt2) my->Cnt2 --;
  // ֥å
  if ((Root->Key & KSShot) && my->Cnt3 == 0)
    SetSub(my);
  if (my->Cnt3) my->Cnt3 --;
  // 㡼å
  if (Root->ChargeCnt < CHARGE_MAX) Root->ChargeCnt ++;
  if ((Root->Key & KCShot) && Root->ChargeCnt == CHARGE_MAX) {
    Root->ChargeCnt = 0;
    CreateChargeShot();
  }
  return RcHitNone;
}
//========================================
// ᥤ
//========================================
void SetMain(CharacterData *my)
{
  Sint16 sx = my->X - 3 + PixMy->data[my->FrameNo].img->Width / 2;
  Sint16 sy = my->Y - 10;

  KXL_PlaySound(SE_GO, KXL_SOUND_PLAY);
  CreateMainShot(sx, sy);
  if (Root->MainLevel > 0) {
    CreateMainShot(sx - 8, sy + 4);
    CreateMainShot(sx + 8, sy + 4);
  }
  if (Root->MainLevel > 1) {
    CreateMainShot(sx - 16, sy + 10);
    CreateMainShot(sx + 16, sy + 10);
  }
  my->Cnt2 = 6;
}
//========================================
// åȼ
//========================================
Sint16 GetTarget(void)
{
  Sint16 i;

  for (i = 0; i < MAX_YOUR; i ++) {
    // Ƥ?
    if (Root->Your[i].Chr.Active == False) continue;
    // ˤ?
    if (Root->Your[i].Chr.Y < UP_TOP) continue;
    // Ũ?
    if (Root->Your[i].Chr.Attr & AttrEnemy && Root->Your[i].Chr.Target & AttrMy)
      return i;
  }
  return -1;
}
//========================================
// 
//========================================
void SetSub(CharacterData *my)
{
//  Uint16 i;
  KXL_Rect m = {6, 6, 2, 2};

  KXL_PlaySound(SE_SHOT, KXL_SOUND_PLAY);
  if (Root->SubNo == 0) { // ư
    KXL_Rect t = {my->AddX + 6, my->AddY + 6, 2, 2};

    CreateSubShot0(0, KXL_GetDirection(m, t));
    my->Cnt3 = 8;
  } else if (Root->SubNo == 1) { // ܥ
    CreateSubShot1();
    my->Cnt3 = 4000 / FRAME_RATE;
  } else if (Root->SubNo == 2) { // ϰϤȯ
    CreateSubShot2();
    my->Cnt3 = 12;
  } else if (Root->SubNo == 3) {
    switch (Root->SubLevel) { // ߥ
    case 3:
      CreateSubShot3(-4, -5, GetTarget());
      CreateSubShot3( 4,  5, GetTarget());
    case 2:
      CreateSubShot3(-4,  0, GetTarget());
      CreateSubShot3( 4,  0, GetTarget());
    case 1:
      CreateSubShot3( 0,  0, GetTarget());
    case 0:
      CreateSubShot3( 0, -5, GetTarget());
      CreateSubShot3( 0,  5, GetTarget());
      break;
    }
    my->Cnt3 = 32;
  } else if (Root->SubNo == 4) {
    KXL_Rect t = {my->AddX + 6, my->AddY + 6, 2, 2};
    Uint16 d = KXL_GetDirection(m, t);
    
    d = ((d >= 45 && d <= 135) ? 135 :
         (d >= 225 && d <= 315) ? 225 :
         180);
    CreateSubShot0(0, d);
    my->Cnt3 = 8;
  }
}
//========================================
// 
//========================================
RcHitEnum HitShip(CharacterData *my, CharacterData *your)
{
  if (your->Attr & AttrItem) { // ƥ
    KXL_PlaySound(SE_POW, KXL_SOUND_PLAY);
    if (your->FrameNo == 5) { // ᥤ󥢥ƥ
      if (Root->MainLevel < 3) Root->MainLevel ++;
    } else { // ֥ƥ
      if (Root->SubNo == your->FrameNo) { // Ʊ쥢ƥ
        if (Root->SubLevel < 3) Root->SubLevel ++;
      } else { // 㤦ƥ
        if (Root->SubLevel > 0) Root->SubLevel --; // ٥
        Root->SubNo = your->FrameNo;
        my->Cnt3 = 0;
      }
    }
    // 1ô̵Ũˤ
    Root->My[MY_NO].Chr.Attr    = AttrMy;
    Root->My[MY_NO].Chr.Target  = AttrItem;
    Root->My[MY_NO].Chr.Cnt1    = 1000 / FRAME_RATE;
  } else if (my->Cnt1 == 0) { // ̵Ũʳȯ
    Root->My[MY_NO].Chr.Attr    = AttrNone;
    Root->My[MY_NO].Chr.Target  = AttrNone;
    Root->My[MY_NO].Chr.Spr     = PixBomb1;
    Root->My[MY_NO].Chr.FrameNo = 0;
    Root->My[MY_NO].Move        = MoveShipBomb;
    KXL_PlaySound(SE_BOMB, KXL_SOUND_PLAY);
  }
  return RcHitNone;
}
//========================================
// ȯ
//========================================
RcHitEnum MoveShipBomb(CharacterData *my)
{
  Uint8 i;

  if (++ my->FrameNo < 12) { // ȯ
    return RcHitNone;
  } else {
    if (-- Root->Life >= 0) { // ĵ
      Root->My[MY_NO].Chr.Attr    = AttrMy;
      Root->My[MY_NO].Chr.Target  = AttrItem;
      Root->My[MY_NO].Chr.Cnt1    = 2000 / FRAME_RATE;
      Root->My[MY_NO].Chr.Spr     = PixMy;
      Root->My[MY_NO].Chr.FrameNo = 2;
      Root->My[MY_NO].Move        = MoveShip;
      Root->My[MY_NO].Draw        = DrawImageFrame;
      Root->My[MY_NO].Hit         = HitShip;
      if (Root->MainLevel) Root->MainLevel --;
      if (Root->SubLevel) Root->SubLevel --;
      for (i = 0; i < SUB3MAX; i ++) sub3data[i].Active = False;
    } else { // ĵʤ
      // ४С
      Root->Life     = 0;
      Root->Cnt      = -1;
      Root->MainFlag = MainGameOver;
      return RcHitDel;
    }
  }
  return RcHitNone;
}
//========================================
// ᥤ
//========================================
void CreateMainShot(Sint16 x, Sint16 y)
{
  Cchr.Attr    = AttrMShot;
  Cchr.Target  = AttrEnemy | AttrEBomb;
  Cchr.Power   = Root->MainLevel == 3 ? 2 : 1;
  Cchr.X       = x;
  Cchr.Y       = y;
  GetDirectionAdd(180, &(Cchr.AddX), &(Cchr.AddY), 20);
  Cchr.Spr     = PixMyLaser;
  Cchr.FrameNo = Root->MainLevel == 3 ? 1 : 0;
  CopyMyNew(MoveStandardNoFrame, HitMainShot, DrawImageFrame);
}
//========================================
// ᥤ
//========================================
RcHitEnum HitMainShot(CharacterData *my, CharacterData *your)
{
  if (my->Spr == PixMySub3)
    sub3data[my->Cnt2].Active = False;
  Cchr.Attr     = AttrNone;
  Cchr.Target   = AttrNone;
  Cchr.Spr      = PixHit;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.X        = ((my->X + my->Spr->data[0].img->Width / 2)
                   - (Cchr.Spr->data[0].img->Width / 2));
  Cchr.Y        = ((my->Y + my->Spr->data[0].img->Height / 2)
                   - (Cchr.Spr->data[0].img->Height / 2));
  CopyMyNew(MoveBomb, HitNone, DrawImageFrame);
  return RcHitDel;
}
//========================================
// 0
//========================================
void CreateSubShot0(Sint16 x, Uint16 dir)
{
  Cchr.Attr     = AttrMShot;
  Cchr.Target   = AttrEnemy | AttrEBomb;
  Cchr.Power    = 1 + Root->SubLevel;
  if (Root->SubLevel == 0) Cchr.Spr = PixMySub00;
  else if (Root->SubLevel == 1) Cchr.Spr = PixMySub01;
  else if (Root->SubLevel == 2) Cchr.Spr = PixMySub02;
  else Cchr.Spr = PixMySub03;
  Cchr.FrameNo  = dir / 45;
  Cchr.X        = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
                   Cchr.Spr->data[0].img->Width / 2) + x;
  Cchr.Y        = (Root->My[MY_NO].Chr.Y + PixMy->data[0].img->Height / 2 -
                   Cchr.Spr->data[0].img->Height / 2);
  GetDirectionAdd(dir, &(Cchr.AddX), &(Cchr.AddY), 16);
  CopyMyNew(MoveStandardNoFrame, HitMainShot, DrawImageFrame);
}
//========================================
// 1
//========================================
void CreateSubShot1(void)
{
  Cchr.Attr     = AttrMShot;
  Cchr.Target   = AttrNone;
  Cchr.Spr      = PixMySub30;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.X        = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
                   Cchr.Spr->data[0].img->Width / 2);
  Cchr.Y        = (Root->My[MY_NO].Chr.Y + PixMy->data[0].img->Height / 2 -
                   Cchr.Spr->data[0].img->Height / 2);
  Cchr.AddX     = 0;
  Cchr.AddY     = -16;
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = (Root->SubLevel + 1) * 16;
  CopyMyNew(MoveSubShot1, HitNone, DrawImageFrame);
}
//========================================
// 1ư
//========================================
RcHitEnum MoveSubShot1(CharacterData *my)
{
  if (my->AddY) {
    my->Y += my->AddY ++;
    my->Cnt1 ++;
    if (my->Cnt1 & 1) my->FrameNo ++;
    if (my->FrameNo == my->FrameMax) my->FrameNo -= 2;
  } else {
    if ((my->Cnt2 & (3 + Root->SubLevel)) == 0)
      KXL_PlaySound(SE_GO, KXL_SOUND_PLAY);
    Cchr.Attr     = AttrMBomb | AttrMShot;
    Cchr.Target   = AttrEnemy | AttrEShot | AttrEBomb;
    Cchr.Spr      = PixMySub1;
    Cchr.FrameNo  = 0;
    Cchr.FrameMax = Cchr.Spr->max;
    Cchr.Power    = 1;
    Cchr.X        = UP_LEFT + RM(WIDTH / Cchr.Spr->data[0].img->Width) * Cchr.Spr->data[0].img->Width;
    Cchr.Y        = UP_TOP + RM(HEIGHT / Cchr.Spr->data[0].img->Height) * Cchr.Spr->data[0].img->Height;
    Cchr.Cnt1     = 15;
    CopyMyNew(MoveSubShotBomb, HitNone, DrawImageFrame);
    if (-- my->Cnt2 == 0)
      return RcHitDel;
  }
  return RcHitNone;
}
//========================================
// 1,2ȯ
//========================================
RcHitEnum MoveSubShotBomb(CharacterData *my)
{
  if (++ my->FrameNo ==my->FrameMax)
    my->FrameNo = 0;
  return (-- my->Cnt1) ? RcHitNone : RcHitDel;
}
//========================================
// 2
//========================================
void CreateSubShot2(void)
{
  Cchr.Attr    = AttrMShot;
  Cchr.Target  = AttrEnemy | AttrEBomb;
  Cchr.Spr     = PixMySub3;
  Cchr.FrameNo = 6;
  Cchr.Power   = 1;
  Cchr.X       = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
                  Cchr.Spr->data[Cchr.FrameNo].img->Width / 2);
  Cchr.Y       = (Root->My[MY_NO].Chr.Y + PixMy->data[0].img->Height / 2 -
                  Cchr.Spr->data[Cchr.FrameNo].img->Height / 2);
  Cchr.AddY    = 0;
  CopyMyNew(MoveSubShot2, HitSubShot2, DrawImageFrame);
}
//========================================
// 2ư
//========================================
RcHitEnum MoveSubShot2(CharacterData *my)
{
  if (my->AddY > -20) my->AddY --;
  my->Y += my->AddY;
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height) return RcHitDel;
  return RcHitNone;
}
//========================================
// 2
//========================================
RcHitEnum HitSubShot2(CharacterData *my, CharacterData *your)
{
  Sprite *spr;

  Cchr.Attr     = AttrMShot;
  Cchr.Target   = AttrEnemy | AttrEBomb;
  if (Root->SubLevel == 0) spr = PixMySub20;
  else if (Root->SubLevel == 1) spr = PixMySub21;
  else if (Root->SubLevel == 2) spr = PixMySub22;
  else spr = PixMySub23;
  Cchr.Spr      = spr;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = spr->max;
  Cchr.Power    = 1;
  Cchr.X        = ((my->X + my->Spr->data[0].img->Width / 2)
                   - (spr->data[0].img->Width / 2));
  Cchr.Y        = ((my->Y + my->Spr->data[0].img->Height / 2)
                   - (spr->data[0].img->Height / 2));
  Cchr.Cnt1     = 300 / FRAME_RATE;
  CopyMyNew(MoveSubShotBomb, HitNone, DrawImageFrame);
  return RcHitDel;
}
//========================================
// 3
//========================================
void CreateSubShot3(Sint16 x, Sint16 add, Uint16 no)
{
  Uint8 i, j;

  Cchr.Attr     = AttrMShot;
  Cchr.Target   = AttrEnemy | AttrEBomb;
  Cchr.Spr      = PixMySub3;
  Cchr.FrameNo  = 0;
  Cchr.Power    = 1 + Root->SubLevel;
  Cchr.X        = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
                   Cchr.Spr->data[0].img->Width / 2) + x - 2;
  Cchr.Y        = (Root->My[MY_NO].Chr.Y + PixMy->data[0].img->Height / 2 -
                   Cchr.Spr->data[0].img->Height / 2);
  Cchr.AddX     = add;
  Cchr.AddY     = 16;
  Cchr.Cnt1     = no;
  for (i = 0; i < SUB3MAX; i ++) {
    if (sub3data[i].Active == True) continue;
    sub3data[i].Active = True;
    for (j = 0; j < 4; j ++) {
      sub3data[i].xy[j].x = Cchr.X;
      sub3data[i].xy[j].y = Cchr.Y;
    }
    break;
  }
  Cchr.Cnt2     = i;
  CopyMyNew(MoveSubShot3, HitMainShot, DrawImageFrame);
}
//========================================
// 3ư
//========================================
RcHitEnum MoveSubShot3(CharacterData *my)
{
  KXL_Rect m = {10, 16, 2, 2};
  KXL_Rect t = m;
  Uint16 x = my->Cnt1 >= 0 ? Root->Your[my->Cnt1].Chr.X : UP_LEFT + WIDTH / 2;
  Uint16 y = my->Cnt1 >= 0 ? Root->Your[my->Cnt1].Chr.Y : UP_TOP - m.Top;
  Uint8 i;

  for (i = 3; i > 0; i --)
    sub3data[my->Cnt2].xy[i] = sub3data[my->Cnt2].xy[i - 1];
  sub3data[my->Cnt2].xy[0].x = my->X;
  sub3data[my->Cnt2].xy[0].y = my->Y;
  for (i = 0; i < 4; i ++)
    KXL_PutImage(my->Spr->data[my->Spr->max - 1].img,
                 sub3data[my->Cnt2].xy[i].x,
                 sub3data[my->Cnt2].xy[i].y);

  if (Root->Your[my->Cnt1].Chr.Active == False ||
      (Root->Your[my->Cnt1].Chr.Target & AttrMy) == 0) my->Cnt1 = -1;
  if (my->X < x) { // 
    if (my->AddX < m.Left) my->AddX += 2;
  } else { // 
    if (my->AddX > -m.Left) my->AddX -= 2;
  }
  if (my->Y < y) { // 
    if (my->AddY < m.Top) my->AddY += 2;
  } else { // 
    if (my->AddY > -m.Top) my->AddY -= 2;
  }
  my->X += my->AddX;
  my->Y += my->AddY;
  t.Left += my->AddX;
  t.Top  += my->AddY;
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height ||
      my->Y > UP_BOTTOM + 64 ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width - 32||
      my->X > UP_RIGHT + 32) {
    sub3data[my->Cnt2].Active = False;
    return RcHitDel;
  }
  my->FrameNo = KXL_GetDirection(m, t) / 30;
  return RcHitNone;
}
//========================================
// 㡼åȺ
//========================================
void CreateChargeShot(void)
{
  Cchr.Attr     = AttrNone;
  Cchr.Target   = AttrNone;
  Cchr.Spr      = PixMyCShot;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.X        = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
		   Cchr.Spr->data[Cchr.FrameNo].img->Width / 2);
  Cchr.Y        = (Root->My[MY_NO].Chr.Y -
		   Cchr.Spr->data[Cchr.FrameNo].img->Height / 2);
  Cchr.Cnt1     = 0;
  Cchr.AddX     = 0;
  CopyMyNew(MoveChargeShot, HitChargeShot, DrawImageFrame);
  KXL_PlaySound(SE_MBOMB, KXL_SOUND_PLAY);
}
//========================================
// 㡼åȰư
//========================================
RcHitEnum MoveChargeShot(CharacterData *my)
{
  static int fr[8] = {0, 1, 0, 1, 2, 1, 2, 3};
  
  my->FrameNo = fr[my->Cnt1];
  if (my->Cnt1 < 6) {
    my->Cnt1 ++;
    my->X = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
	     my->Spr->data[my->FrameNo].img->Width / 2);
    my->Y = (Root->My[MY_NO].Chr.Y -
	     my->Spr->data[my->FrameNo].img->Height / 2);
  } else if (my->Cnt1 == 6) {
    my->Attr = AttrMBomb;
    my->Target = AttrEShot | AttrEBomb | AttrEnemy;
    my->Power  = 10;
    my->AddY = 4;
    my->X = (Root->My[MY_NO].Chr.X + PixMy->data[0].img->Width / 2 -
	     my->Spr->data[3].img->Width / 2);
    my->Cnt1 ++;
  } else {
    my->AddY ++;
    my->Y -= my->AddY;
    my->X += my->AddX;
    if (my->Y < UP_TOP)
      return RcHitDel;
  }
  return RcHitNone;
}
//========================================
// 㡼å
//========================================
RcHitEnum HitChargeShot(CharacterData *my, CharacterData *your)
{
  if (your->Attr & AttrEnemy) {
    if (my->X + my->Spr->data[0].img->Width / 2 < UP_LEFT + WIDTH / 2)
      my->AddX = 8;
    else
      my->AddX = -8;
  }
  return RcHitNone;
}
//========================================
// 㡼åȥܥ
//========================================
void CreateChargeBomb(Sint16 x, Sint16 y)
{
  Cchr.Attr     = AttrMBomb;
  Cchr.Target   = AttrEnemy;
  Cchr.Spr      = PixMyCShot;
  Cchr.FrameNo  = 3;
  Cchr.Power    = 10;
  Cchr.X        = x - Cchr.Spr->data[Cchr.FrameNo].img->Width / 2;
  Cchr.Y        = y - Cchr.Spr->data[Cchr.FrameNo].img->Height / 2;
  Cchr.Cnt1     = 20;
  CopyMyNew(MoveChargeBomb, HitDelete, DrawImageFrame);
}
//========================================
// 㡼åȥܥư
//========================================
RcHitEnum MoveChargeBomb(CharacterData *my)
{
  if (my->Y < UP_TOP - 8)
    return RcHitDel;
  my->FrameNo = my->FrameNo == 3 ? 2 : 3;
  if (-- my->Cnt1 == 0)
    return RcHitDel;
  return RcHitNone;
}
