//====================================================
// Grande
// Copyright (C) 2002, kacchan
// E-M@il address   fc3srx@mwnet.or.jp
// Homepage address http://www2.mwnet.or.jp/~fc3srx7
//====================================================
#include "grande.h"
#include "extern.h"

#define MCHR Root->My[m].Chr
#define YCHR Root->Your[y].Chr

//========================================
// ʬǡ
//========================================
Sint16 CopyMyNew(RcHitEnum (*act)(CharacterData *my),
                 RcHitEnum (*hit)(CharacterData *my, CharacterData *your),
                 void (*re)(CharacterData *my))
{
  Uint16 i;
  
  for (i = 0; i < MAX_MY; i ++) {
    if (Root->My[i].Chr.Active == True) continue;
    Root->My[i].Chr        = Cchr;
    Root->My[i].Chr.CntX   = Root->My[i].Chr.X << 8;
    Root->My[i].Chr.CntY   = Root->My[i].Chr.Y << 8;
    Root->My[i].Move       = act;
    Root->My[i].Hit        = hit;
    Root->My[i].Draw       = re;
    Root->My[i].Chr.Active = True;
    return i;
  }
  return -1;
}
//========================================
// Ũǡ
//========================================
Sint16 CopyYourNew(RcHitEnum (*act)(CharacterData *my),
                RcHitEnum (*hit)(CharacterData *my, CharacterData *your),
                void (*re)(CharacterData *my))
{
  Uint16 i;

  for (i = 6; i < MAX_YOUR; i ++) {
    if (Root->Your[i].Chr.Active == True) continue;
    Root->Your[i].Chr        = Cchr;
    Root->Your[i].Chr.CntX   = Root->Your[i].Chr.X << 8;
    Root->Your[i].Chr.CntY   = Root->Your[i].Chr.Y << 8;
    Root->Your[i].Move       = act;
    Root->Your[i].Hit        = hit;
    Root->Your[i].Draw       = re;
    Root->Your[i].Chr.Active = True;
    return i;
  }
  return -1;
}
//========================================
// Ƚ
//========================================
Bool Check(CharacterData *my, CharacterData *your)
{
  KXL_Rect mm, yy;

  mm = my->Spr->data[my->FrameNo].r;
  yy = your->Spr->data[your->FrameNo].r;
  mm.Left += my->X;
  mm.Top  += my->Y;
  yy.Left += your->X;
  yy.Top  += your->Y;
  return KXL_RectIntersect(mm, yy);
}
//========================================
// Ũȯ
//========================================
void SetEnemy(void)
{
  Uint16 i;

  for (i = 0; i < Root->StageMax; i ++) {
    // Ũȯ?
    if (Root->EnemyCnt != StageDatas[i].Time) continue;
    // ޤȯƤʤ?
    if (StageDatas[i].Flag == True) continue;
    // Ũȯ
    StageDatas[i].Flag = True;
  }
  for (i = 0; i < Root->StageMax; i ++) {
    // Ũȯ?
    if (StageDatas[i].Flag == False) continue;
    // ޤȯƤʤ?
    if (StageDatas[i].Max) {
      // ȯֳ֤OK?
      if (StageDatas[i].StepTime == 0) {
        // ȯ
        StageDatas[i].Max --;
        // ȯֳֻ
        StageDatas[i].StepTime = StageDatas[i].Step;
        // Ũȯ
        switch (StageDatas[i].CreateNo) {
        case 0:
          {
            void (*boss[])(Uint8 *x, Uint8 *y) = {
              CreateBoss1,
              CreateBoss2,
              CreateBoss3,
              CreateBoss4
              };
            boss[Root->Stage](StageDatas[i].X, StageDatas[i].Y);
          }
          break;
        case 1:
        case 2:
        case 3:
          CreateEnemy1_3(StageDatas[i].X, StageDatas[i].Y,
                         StageDatas[i].CreateNo - 1);
          break;
        case 4:
        case 5:
          CreateEnemy4_5(StageDatas[i].X, StageDatas[i].Y,
                         StageDatas[i].CreateNo - 4);
          break;
        case 6:
          CreateEnemy6(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 7:
          CreateEnemy7(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 8:
          CreateEnemy8(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 9:
          CreateEnemy9(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 10:
          CreateEnemy10(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 11:
          CreateEnemy11(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 12:
          CreateEnemy12();
          break;
        case 13:
          CreateEnemy13(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 14:
          CreateEnemy14(StageDatas[i].X, StageDatas[i].Y);
          break;
        case 15:
          CreateEnemy15(StageDatas[i].X, StageDatas[i].Y);
          break;
        default:
          break;
        }
      } else {
        // ȯֳָֻ
        StageDatas[i].StepTime --;
      }
    } else {
      // ȯ
      StageDatas[i].Flag = False;
    }
  }
  // Ũȯֹ
  if (Root->EnemyCnt < 10000) Root->EnemyCnt ++;
}
//========================================
// طʥ
//========================================
void MoveBack(void)
{
  Uint8 x, y;
  Uint8 *d;

  // 
  for (y = 0; y < 11; y++) {
    d = Back[Root->BackLine + y];
    for (x = 0; x < 12; x++)
      KXL_PutImage(PixBack->data[*(d ++)].img,
                   UP_LEFT + x * 32,
                   UP_BOTTOM - 31 - y * 32 + Root->BackAdd);
  }
  // ư
  if (Root->BackLine < Root->BackMax - 12) {
    Root->BackAdd += 1;
    if (Root->BackAdd >= 32) {
      Root->BackLine ++;
      Root->BackAdd -= 32;
    }
  }
}
//========================================
// Ũư
//========================================
void MoveEnemy(void)
{
  Uint16 y;
  RcHitEnum rc;

  for (y = 0; y < MAX_YOUR; y ++) {
    if (YCHR.Active == False) continue;
    rc = Root->Your[y].Move(&(YCHR));
    switch (rc) {
    case RcHitDel: // ̳˾ä
      YCHR.Active = False;
      break;
    case RcHitBoss: // ܥ˲줿
      Root->Score += YCHR.Score;
      if (Root->Score >= Root->OneUp) {
        Root->Life ++;
        Root->OneUp += 5000;
      }
      if (Root->Score > Root->HiScore) Root->HiScore = Root->Score;
      for (y = 0; y < MAX_YOUR; y ++)
	YCHR.Active = False;
      Root->Cnt = 0;
      Root->MainFlag = MainClear;
      return;
    default:
      break;
    }
  }
}
//========================================
// ʬư
//========================================
void MoveMy(void)
{
  Uint16 m;
  
  for (m = 0; m < MAX_MY; m ++) {
    if (MCHR.Active == False) continue;
    if (Root->My[m].Move(&(MCHR)) == RcHitDel)
      MCHR.Active = False;
  }
}
//========================================
// Ƚ
//========================================
void CheckHit(void)
{
  RcHitEnum rc;
  Uint16 m, y;

  for (m = 0; m < MAX_MY; m ++) {
    // ʬƤ?
    if (MCHR.Active == False) continue;
    for (y = 0; y < MAX_YOUR; y ++) {
      // ŨƤ?
      if (YCHR.Active == False) continue;
      // ʬ¦Υåȼ̻ҤȡŨ¦μ̻,
      // Ũ¦Υåȼ̻Ҥȡʬ¦μ̻Ҥ?
      if ((MCHR.Target & YCHR.Attr) && (YCHR.Target & MCHR.Attr)) {
        // ä?
        if (Check(&(MCHR), &(YCHR)) == False) continue;
        // ʬ
        if (Root->My[m].Hit(&(MCHR), &(YCHR)) == RcHitDel)
          MCHR.Active = False;
        // Ũ
        rc = Root->Your[y].Hit(&(YCHR), &(MCHR));
        switch (rc) {
	case RcHitNone:
	  break;
        case RcHitDel:
          YCHR.Active = False;
	  break;
        case RcHitBomb: // ˲줿
          YCHR.Active = False;
	case RcHitTank: // ˲줿ɾäʤ
          Root->Score += YCHR.Score;
          if (Root->Score >= Root->OneUp) {
            Root->Life ++;
            Root->OneUp += 5000;
          }
          if (Root->Score > Root->HiScore) Root->HiScore = Root->Score;
          break;
        }
      }
    }
  }
}
//========================================
// ᡼
//========================================
void PutImage(void)
{
  Uint16 m, y;

  // ŨαƵڤϾʪ
  for (y = 0; y < MAX_YOUR; y ++) {
    if (YCHR.Active == False) continue;
    if (YCHR.Attr & AttrShadow)
      KXL_PutImage(YCHR.Spr->data[YCHR.Spr->max / 2 + YCHR.FrameNo].img,
                   YCHR.X + YCHR.Spr->data[0].img->Width,
                   YCHR.Y + YCHR.Spr->data[0].img->Height / 2);
    else if (YCHR.Attr & AttrTank)
      Root->Your[y].Draw(&(YCHR));
  }
  // ʬα
  m = MY_NO;
  if (MCHR.Active == True && (MCHR.Attr & AttrShadow))
    KXL_PutImage(MCHR.Spr->data[MCHR.Spr->max / 2 + MCHR.FrameNo].img,
                 MCHR.X + MCHR.Spr->data[0].img->Width,
                 MCHR.Y + MCHR.Spr->data[0].img->Height / 2);
  // Ũζʪ
  for (y = 0; y < MAX_YOUR; y ++)
    if (YCHR.Active == True && (YCHR.Attr & AttrTank) == 0)
      Root->Your[y].Draw(&(YCHR));
  // ʬ
  for (m = 0; m < MAX_MY; m ++)
    if (MCHR.Active == True)
      Root->My[m].Draw(&(MCHR));
}
//========================================
// ե᡼
//========================================
void Infomation(void)
{
  Uint8 buff[30];
  Uint8 i;
  Uint16 w;
  
  // ĵ
  sprintf(buff, "Life %d",  Root->Life);
  for (i = 0; i < 2; i ++) {
    KXL_Font(NULL, 0xff * i, 0xff * i, 0xff * i);
    KXL_PutText(UP_LEFT + 22 - i * 2, UP_TOP + 14 - i * 2, buff);
  }
  // 
  sprintf(buff, "Score %06lu", Root->Score);
  for (i = 0; i < 2; i ++) {
    KXL_Font(NULL, 0xff * i, 0xff * i, 0xff * i);
    KXL_PutText(UP_LEFT + 142 - i * 2, UP_TOP + 14 - i * 2, buff);
  }
  // Υ٥
  if (Root->SubLevel == 3)
    sprintf(buff, "Sub %d-Max", Root->SubNo);
  else
    sprintf(buff, "Sub %d-%d", Root->SubNo, Root->SubLevel + 1);
  for (i = 0; i < 2; i ++) {
    KXL_Font(NULL, 0xff * i, 0xff * i, 0xff * i);
    KXL_PutText(UP_LEFT + 292 - i * 2, UP_TOP + 14 - i * 2, buff);
  }
  // 㡼ͥ륮
  KXL_PutImage(PixChargeBack, UP_LEFT, UP_BOTTOM - PixChargeBack->Height - 8);
  w = (float)PixCharge->Width * ((float)Root->ChargeCnt / (float)CHARGE_MAX);
  if (w)
    KXL_PutImageImm(PixCharge, 0, 0, w, PixCharge->Height,
		    UP_LEFT + 5, UP_BOTTOM - PixChargeBack->Height - 6);
}
//========================================
// ᥤ
//========================================
void Game(Bool flag)
{
  if (flag == True) {
    MoveBack();  // طʰư
    if (Root->MainFlag == MainGame)
      SetEnemy();  // Ũȯ
    MoveEnemy(); // Ũư
    MoveMy();    // ʬư
    CheckHit();  // Ƚ
  }
  PutImage();    // ᡼
  Infomation();  // ե᡼
}
