/* CrazyCars 0.1 (GPLv3)
Hecho por Andreu Fortuño, Eduard Carrillo y Arnau Crous.
Proyecto Final 2o DAI (Programación Avanzada)
Limpiado y adaptado para correr en una Sega Dreamcast por Indiket - Dreamcast.es :)
*/

#include <iostream>
#include <stdlib.h>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
using namespace std;

#if DREAMCAST
	#include <kos.h>
	#include <SDL/SDL_dreamcast.h>
	KOS_INIT_FLAGS(INIT_DEFAULT);
	#define SPEED 2
#else
	#define SPEED 4
#endif

/* ----- Funciones auxiliares para fuentes ----*/
SDL_Surface *screen; /* La pantalla */
SDL_Surface *fondo;
SDL_Surface *inicio;
SDL_Surface *sem1,*sem2,*sem3;


struct tipoFuente{
  SDL_Surface *imagen;
  int ancho, alto;
  int anchoLetra, altoLetra;
  int primeraLetra;
} fuente;

void leerFuente() {
   fuente.imagen = SDL_LoadBMP("ficheros/font_arial.bmp"); 
   /* Los siguientes valores son prefijados para la fuente
   de ejemplo: 16x16 caracteres, cada uno de 16x16 pixels;
   habria que modificarlo si se usan fuentes de otro tamño */
   fuente.ancho=256;
   fuente.alto=256;
   fuente.anchoLetra=16;
   fuente.altoLetra=16;
   fuente.primeraLetra=0;
 }

void escribirLetra(int x, int y, char letra) {
  SDL_Rect destino, origen; 
 int fila, columna;
 int letrasPorFila, letrasPorColumna;
    
 letrasPorFila = fuente.ancho/fuente.anchoLetra;
 letrasPorColumna = fuente.alto/fuente.altoLetra;
 fila = letra / letrasPorColumna;
 columna = letra % letrasPorColumna;
 origen.x = columna * fuente.anchoLetra;
 origen.y = fila * fuente.altoLetra;
 origen.w = 16;
 origen.h = 16;
 destino.x = x;
 destino.y = y;
 SDL_BlitSurface(fuente.imagen, &origen, screen, &destino); 

}

void escribirFrase(int x, int y, char *frase) {
  int i;
  for (i=0; i<(int)strlen(frase); i++)
    escribirLetra(x+i*fuente.anchoLetra, y, frase[i]);
}
/* ------ Fin de funciones para fuentes ------ */

/* ------ CLASE RODA ------ */

class roda{
    private:
	    SDL_Surface *imatge;
	    SDL_Rect posicio;

    public:
        roda();
        void posicionar(int, int);
        void pintar(SDL_Surface*);
        SDL_Rect getPosicio(){return posicio;};
};

class escena{
    private:
    	int n_rodes;
    public:
    	roda* t_rodes[1000];
    	escena();
    	void pintar(SDL_Surface*);
    	int getnrodes(){return n_rodes;}
};


roda::roda(){
	imatge = SDL_LoadBMP("ficheros/neumatic.bmp");
}

void roda::posicionar(int x,int y){
	posicio.x = x;
	posicio.y = y;

	posicio.h = imatge->h;
	posicio.w = imatge->w;
}

void roda::pintar(SDL_Surface* screen){
	SDL_BlitSurface(imatge, NULL, screen, &posicio);
}

/* ------ CLASE JUGADOR ------ */

class jugador{
	SDL_Surface *imatge;
	SDL_Rect posicio;
	int vx, vy;

public:
	jugador();
	jugador(int);
	void posicionar(int, int);
	void pintar(SDL_Surface*);
	void borrar(SDL_Surface*);
	void moure();
	void canvia_direccio(int, int);
	bool colisiona(escena sc);
	void aturar();
	void pas_enrere();
	int meta();
	#ifdef DREAMCAST
	SDL_Rect getPosicio(){posicio.w = 32; return posicio;};
	#else
	SDL_Rect getPosicio(){posicio.w = 40; return posicio;};
	#endif
};

void jugador::pas_enrere(){
	if (vx == 1) posicionar(getPosicio().x-SPEED, getPosicio().y);
	if (vx == -1) posicionar(getPosicio().x+SPEED , getPosicio().y);
	if (vy == 1) posicionar(getPosicio().x , getPosicio().y-SPEED);
	if (vy == -1) posicionar(getPosicio().x , getPosicio().y+SPEED);
}

bool colisio(SDL_Rect a, SDL_Rect b){
	bool solapamentx = false;
	bool solapamenty = false;

	if (((a.x >= b.x) && (a.x <= (b.x + b.w))) || ((b.x >= a.x) && (b.x <= (a.x + a.w)))) solapamentx = true;
	if (((a.y >= b.y) && (a.y <= (b.y + b.h))) || ((b.y >= a.y) && (b.y <= (a.y + a.h)))) solapamenty = true;
	return solapamentx && solapamenty;
}

bool colisiocotxe(SDL_Rect a, SDL_Rect b){
	bool solapamentx = false;
	bool solapamenty = false;

	if (((a.x >= b.x) && (a.x <= (b.x+30))) || ((b.x >= a.x) && (b.x <= (a.x+30)))) solapamentx = true;
	if (((a.y >= b.y) && (a.y <= (b.y +20))) || ((b.y >= a.y) && (b.y <= (a.y +20)))) solapamenty = true;
	return solapamentx && solapamenty;
}


bool jugador::colisiona(escena sc){
	
	for (int i=0; i<sc.getnrodes(); i++){
		if (colisio(sc.t_rodes[i]->getPosicio(), getPosicio())) 
			return true;
	}
	return false;
}

void jugador::canvia_direccio(int velx, int vely){
	vx = velx;
	vy = vely;
}

jugador::jugador(){
	imatge = SDL_LoadBMP("ficheros/jugador4.bmp");
	SDL_SetColorKey(imatge, SDL_SRCCOLORKEY, SDL_MapRGB(imatge->format, 255, 255, 255));
	vx = 1;
	vy = 0;
}

jugador::jugador(int n){
	imatge = SDL_LoadBMP("ficheros/jugador5.bmp");
	SDL_SetColorKey(imatge, SDL_SRCCOLORKEY, SDL_MapRGB(imatge->format, 255, 255, 255));
	vx = 1;
	vy = 0;
}

void jugador::aturar(){
	pas_enrere();
}

void jugador::moure(){
	posicio.x = posicio.x + (vx*SPEED);
	posicio.y = posicio.y + (vy*SPEED);
}

void jugador::posicionar(int x,int y){
	posicio.x = x;
	posicio.y = y;

	posicio.h = imatge->h;
	posicio.w = imatge->w;
}

void jugador::pintar(SDL_Surface* screen){

	//Elije sprite a pintar según la tecla pulsada
	SDL_Rect finestra;
	#ifdef DREAMCAST
		finestra.h = 32;
		finestra.w = 32;
		finestra.y = 0;

		if (vx == 1 && vy == -1) finestra.x = 128;//0;
		else if (vx == -1 && vy == -1) finestra.x = 160;//80;
		else if (vx == 1 && vy == 1) finestra.x = 192;//40;
		else if (vx == -1  && vy == 1) finestra.x = 224;//120;
		else if (vx == 1) finestra.x = 0;
		else if (vx == -1) finestra.x = 64;
		else if (vy == 1) finestra.x = 32;
		else if (vy == -1) finestra.x = 96;
	#else
		finestra.h = 40;
		finestra.w = 40;
		finestra.y = 0;

		if (vx == 1 && vy == -1) finestra.x = 160;//0;
		else if (vx == -1 && vy == -1) finestra.x = 200;//80;
		else if (vx == 1 && vy == 1) finestra.x = 240;//40;
		else if (vx == -1  && vy == 1) finestra.x = 280;//120;
		else if (vx == 1) finestra.x = 0;
		else if (vx == -1) finestra.x = 80;
		else if (vy == 1) finestra.x = 40;
		else if (vy == -1) finestra.x = 120;
	#endif
    
	SDL_Rect aux;
	aux = posicio;
	SDL_BlitSurface(imatge,&finestra, screen, &aux);
}

void jugador::borrar(SDL_Surface* screen){

	SDL_Rect finestra;
	#ifdef DREAMCAST
		finestra.h = 32;
		finestra.w = 32;
	#else
		finestra.h = 40;
		finestra.w = 40;
	#endif
	
	SDL_Rect aux = posicio;
	
	//Finextra x i y
	finestra.x = aux.x;
	finestra.y = aux.y;
    
	SDL_BlitSurface(fondo,&finestra, screen, &aux);
}

int jugador::meta(){
	#ifdef DREAMCAST
		if(posicio.x==320&&	 posicio.y>32 && posicio.y<120 && vx==1){
			return 1;
		}
		else if(posicio.x==320&&	  posicio.y>32 && posicio.y<120 && vx==-1) 
			return -1;
		else return 0;
	#else
		if(posicio.x==400&&	 posicio.y>40 && posicio.y<150 && vx==1){
			return 1;
		}
		else if(posicio.x==400&&	  posicio.y>40 && posicio.y<150 && vx==-1) 
			return -1;
		else return 0;
	#endif
}



escena::escena(){
	n_rodes=0;
	
	#ifdef DREAMCAST
		int tamanyroda = 32;
		int w = 640;
		int y = 480;
	#else
		int tamanyroda = 40;
		int w = 800;
		int y = 600;
	#endif
	
	//Dibuxem el marc
	for(int i=0; i<w;i=i+tamanyroda){
		t_rodes[n_rodes] = new roda();
		t_rodes[n_rodes]->posicionar(i,0);
		n_rodes++;
	}
	for(int i=0; i<w;i=i+tamanyroda){
		t_rodes[n_rodes] = new roda();
		#ifdef DREAMCAST
			t_rodes[n_rodes]->posicionar(i,448);
		#else
			t_rodes[n_rodes]->posicionar(i,560);
		#endif
		n_rodes++;
	}

	#ifdef DREAMCAST
	for(int i=32; i<y;i=i+tamanyroda){
	#else
	for(int i=40; i<y;i=i+tamanyroda){
	#endif
		t_rodes[n_rodes] = new roda();
		t_rodes[n_rodes]->posicionar(0,i);
		n_rodes++;
	}
	#ifdef DREAMCAST
	for(int i=32; i<y;i=i+tamanyroda){
	#else
	for(int i=40; i<y;i=i+tamanyroda){
	#endif
		t_rodes[n_rodes] = new roda();
		#ifdef DREAMCAST
			t_rodes[n_rodes]->posicionar(608,i);
		#else
			t_rodes[n_rodes]->posicionar(760,i);
		#endif
		n_rodes++;
	}
	
	//Vertical (5 ruedas)
	#ifdef DREAMCAST
		for(int i=120; i<300;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(320,i);
			n_rodes++;
		}
	#else
		for(int i=150; i<395;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(400,i);
			n_rodes++;
		}
	#endif
	
	//Horitzontals
	#ifdef DREAMCAST
		for(int i=120; i<520;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,120);
			n_rodes++;
		}
		for(int i=120; i<520;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,320);
			n_rodes++;
		}
		for(int i=0; i<240;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,220);
			n_rodes++;
		}
		for(int i=440; i<600;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,220);
			n_rodes++;
		}
	#else
		for(int i=150; i<650;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,150);
			n_rodes++;
		}
		for(int i=150; i<650;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,400);
			n_rodes++;
		}
		for(int i=0; i<300;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,275);
			n_rodes++;
		}
		for(int i=550; i<800;i=i+tamanyroda){
			t_rodes[n_rodes] = new roda();
			t_rodes[n_rodes]->posicionar(i,275);
			n_rodes++;
		}
	#endif
}

void escena::pintar(SDL_Surface* screen){
	for(int i=0; i<n_rodes;i++){
		t_rodes[i]->pintar(screen);
	}
}

void iniciarcarrera(){
    SDL_BlitSurface(inicio, NULL, screen, 0);
	SDL_Flip(screen); 
    SDL_Delay( 5000 );
    
    SDL_BlitSurface(sem1, NULL, screen, 0);
	SDL_Flip(screen); 
    SDL_Delay( 2000 );
    
    SDL_BlitSurface(sem2, NULL, screen, 0);
	SDL_Flip(screen); 
    SDL_Delay( 2000 );
    
    SDL_BlitSurface(sem3, NULL, screen, 0);
	SDL_Flip(screen); 
    SDL_Delay(500);
}

int main(int argc, char *argv[])
{
	//INIT DC settings
 	#ifdef DREAMCAST
		printf("Starting ...\n");
		fs_chdir("/cd");
	#endif
	
	SDL_Surface *final = SDL_LoadBMP("ficheros/final.bmp");

	int terminado=0;
	SDL_Event suceso;
	Uint8* teclas;
	char cont_voltes='0';
	int volta=0, num_voltes1=0, num_voltes2=0;
	
	 // Iniciamos el subsistema de video
    if(SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK) < 0) {
		cerr << "No se pudo iniciar SDL: " << SDL_GetError() << endl;
		exit(1);
    }
    atexit(SDL_Quit);
    
    // Comprobamos que sea compatible el modo de video
	#ifndef DREAMCAST
		if(SDL_VideoModeOK(800, 600, 16, SDL_HWSURFACE|SDL_DOUBLEBUF) == 0) {
			cerr << "Modo no soportado: " << SDL_GetError() << endl;
			exit(1);
		}
	#endif
    
	/* Si todo ha ido bien, hacemos algo:
		entrar a modo grafico y cambiar el título de la ventana */
	#ifdef DREAMCAST
		screen = SDL_SetVideoMode( 640, 480, 16, SDL_HWSURFACE|SDL_HWPALETTE|SDL_DOUBLEBUF);
	#else
		screen = SDL_SetVideoMode( 800, 600, 16, SDL_HWSURFACE );
	#endif
	
	if(screen == NULL) {
		printf( "Error al entrar a modo grafico: %s\n", SDL_GetError() );
		SDL_Quit();
		return -1;
	}
	
//--------------------------------------AUDIO---------------------------------------------------------------
    // Inicializamos la librería SDL_Mixer
    if(Mix_OpenAudio(22050, AUDIO_S16SYS, 2, 512) < 0) {
		cerr << "Subsistema de Audio no disponible" << endl;
    }
    
    // Al salir cierra el subsistema de audio
    atexit(Mix_CloseAudio);
    
    // Cargamos un fichero para la BSO
    Mix_Music *bso = Mix_LoadMUS("ficheros/outrun.mod");
    if(bso == NULL) {
	    cerr << "No se puede cargar el fichero musical" << endl;
    }
    else{
		Mix_PlayMusic(bso, -1);
	}
//----------------------------------------FI AUDIO-----------------------------------------------------------

	/* Titulo de la ventana */
	/* DREAMCAST: joystick */
	#ifndef DREAMCAST
		SDL_WM_SetCaption( "Crazy cars", "Crazy cars" );
	#else
		SDL_JoystickOpen (0);
		SDL_DC_MapKey(0,SDL_DC_START,SDLK_RETURN);
		SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP);
		SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN);
		SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
		SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
		SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L:exits
		
		SDL_JoystickOpen (1);
		SDL_DC_MapKey(1,SDL_DC_START,SDLK_RETURN);
		SDL_DC_MapKey(1,SDL_DC_UP,SDLK_w);
		SDL_DC_MapKey(1,SDL_DC_DOWN,SDLK_s);
		SDL_DC_MapKey(1,SDL_DC_LEFT,SDLK_a); 
		SDL_DC_MapKey(1,SDL_DC_RIGHT,SDLK_d);
		SDL_DC_MapKey(1,SDL_DC_R,SDLK_ESCAPE); //L:exits
		
		//Dreamcast delay...
		SDL_Event dcevent;
		SDL_PollEvent(&dcevent);
		SDL_DC_EmulateMouse(SDL_FALSE);
	#endif
	
	//Cargamos recursos
	fondo = SDL_LoadBMP("ficheros/fons2.bmp");
    inicio = SDL_LoadBMP("ficheros/benvinguda.bmp");
	sem1= SDL_LoadBMP("ficheros/semaforvermell.bmp");
	sem2= SDL_LoadBMP("ficheros/semaforgroc.bmp");
	sem3= SDL_LoadBMP("ficheros/semaforverd.bmp");
	
	//Pantalla inicial y semaforo
	iniciarcarrera();
	
	//Creamos los coches
	jugador* jugador1 = new jugador();
    jugador* jugador2 = new jugador(2);
	
	//Creamos las ruedas y la fuente	
	escena sc;
	leerFuente();
	
	//Posicionar coches
	#ifdef DREAMCAST
	jugador1->posicionar(320, 72);
	jugador2->posicionar(320, 40);
	#else
	jugador1->posicionar(400, 90);
	jugador2->posicionar(400, 50);
	#endif
	
	//Pintar Background fondo (BMP)
	SDL_BlitSurface(fondo, NULL, screen, 0);
	
	//Pintar las ruedas (posición fija)
	sc.pintar(screen);
	
	while (terminado == 0){
		
		//Borramos los coches (repintar con fondo)
		jugador1->borrar(screen);
		jugador2->borrar(screen);
		
		/* Miramos si hay algun suceso pendiente,
		entre ellos, peticion de abandonar el programa
		(pulsar la X de la ventana) o tecla ESC */
        while (SDL_PollEvent(&suceso)) {
			if (suceso.type == SDL_QUIT)    terminado = 1;
		}

        /* Movimentos jugador1 */
        teclas = SDL_GetKeyState(NULL);
       
		if(teclas[SDLK_ESCAPE]) terminado = 1;
	   
        if(teclas[SDLK_UP] && teclas[SDLK_RIGHT]){
            jugador1->canvia_direccio(1,-1);
			jugador1->moure();

			volta=jugador1->meta();
						
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
        }
       
       else if (teclas[SDLK_UP] && teclas[SDLK_LEFT]) {
			jugador1->canvia_direccio(-1,-1);
			jugador1->moure();

			volta=jugador1->meta();
						
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
        }
       
       else if (teclas[SDLK_DOWN] && teclas[SDLK_RIGHT]) { 
			jugador1->canvia_direccio(1,1);
			jugador1->moure();
			
			volta=jugador1->meta();
			
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
		}
       
       else if (teclas[SDLK_DOWN] && teclas[SDLK_LEFT]) {
			jugador1->canvia_direccio(-1,1);
			jugador1->moure();

			volta=jugador1->meta();
						
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
        }
       
        else if (teclas[SDLK_UP]) { /* TECLA AMUNT */ 
			jugador1->canvia_direccio(0,-1);
			jugador1->moure();

			volta=jugador1->meta();
						
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
        }
			
        else if (teclas[SDLK_DOWN]) { /* TECLA AVALL */ 
			jugador1->canvia_direccio(0,1); 
			jugador1->moure();

			volta=jugador1->meta();
						
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
        }
			
        else if (teclas[SDLK_LEFT]) { /* TECLA ESQ */  
			jugador1->canvia_direccio(-1,0);
			jugador1->moure();

			volta=jugador1->meta();
						
			if (jugador1->colisiona(sc)) 
			    jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}
        }
			
        else if (teclas[SDLK_RIGHT]) { /* TECLA DRE */ 
			jugador1->canvia_direccio(1,0);
			jugador1->moure();
			
			volta=jugador1->meta();
			
			if (jugador1->colisiona(sc)) 
			jugador1->aturar();
			
			num_voltes1=num_voltes1+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador1->aturar();
			}	
		}		
						
						
		/*Moviments jugador2*/
		if(teclas[SDLK_w] && teclas[SDLK_d]){
            jugador2->canvia_direccio(1,-1);
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
       
       else if (teclas[SDLK_w] && teclas[SDLK_a]) {
			jugador2->canvia_direccio(-1,-1);
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
       
       else if (teclas[SDLK_s] && teclas[SDLK_d]) { 
			jugador2->canvia_direccio(1,1);
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
       
       else if (teclas[SDLK_s] && teclas[SDLK_a]) {
			jugador2->canvia_direccio(-1,1);
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
		 
		 
		else if (teclas[SDLK_w]) { /* TECLA AMUNT */ 
			jugador2->canvia_direccio(0,-1);
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
			
        else if (teclas[SDLK_s]) { /* TECLA AVALL */ 
			jugador2->canvia_direccio(0,1); 
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
			
        else if (teclas[SDLK_a]) { /* TECLA ESQ */  
			jugador2->canvia_direccio(-1,0);
			jugador2->moure();

			volta=jugador2->meta();
						
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta;
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
			
        else if (teclas[SDLK_d]) { /* TECLA DRE */ 
			jugador2->canvia_direccio(1,0);
			jugador2->moure();

			volta=jugador2->meta();
			
			if (jugador2->colisiona(sc)) 
			    jugador2->aturar();
			
			num_voltes2=num_voltes2+volta; 
						
			if(colisiocotxe(jugador1->getPosicio(), jugador2->getPosicio ())){
			    jugador2->aturar();
			}
        }
		
		//Repintamos los coches
		jugador1->pintar(screen);
		jugador2->pintar(screen);


		//Control voltes (marca la volta del que va primer)
        if(num_voltes1==1 || num_voltes2==1) cont_voltes='1';
        if(num_voltes1==2 || num_voltes2==2) cont_voltes='2';
        if(num_voltes1==3 || num_voltes2==3) cont_voltes='3';
        if(num_voltes1==4 || num_voltes2==4) cont_voltes='4';
    
		#ifdef DREAMCAST
		escribirFrase(280, 20, "LAP ");
		escribirFrase(340, 20, "/3");
		escribirLetra(325, 20, cont_voltes);
		#else
		escribirFrase(350, 20, "LAP ");
		escribirFrase(410, 20, "/3");
		escribirLetra(400, 20, cont_voltes);
		#endif
		
		/* Actualizamos la pantalla */
		SDL_Flip(screen); 
		
		if(cont_voltes=='4'){
		    
			//Final de la carrera!!
			
			SDL_BlitSurface(final, NULL, screen, 0);
			/* Actualizamos la pantalla */
			if(num_voltes1==4){
				#ifdef DREAMCAST
					escribirFrase(280, 20, "FELICIDADES JUGADOR 1");
				#else
					escribirFrase(350, 20, "FELICIDADES JUGADOR 1");
				#endif
			}
			else if(num_voltes2==4) {
				#ifdef DREAMCAST
					escribirFrase(280, 20, "FELICIDADES JUGADOR 2");
				#else
					escribirFrase(350, 20, "FELICIDADES JUGADOR 2");
				#endif
			}
			SDL_Flip(screen); 
			SDL_Delay( 5000 );
			
			//Reiniciar carrera
			volta=0; num_voltes1=0; num_voltes2=0;
			cont_voltes='0';
			
			iniciarcarrera();
			
			//Posicionar coches
			#ifdef DREAMCAST
				jugador1->posicionar(320, 72);
				jugador2->posicionar(320, 40);
			#else
				jugador1->posicionar(400, 90);
				jugador2->posicionar(400, 50);
			#endif
			
			//Pintar Background fondo (BMP) y ruedas
			SDL_BlitSurface(fondo, NULL, screen, 0);
			sc.pintar(screen);
		}
		
        }
    
	/* Finalmente, preparamos para salir */
	if(bso != NULL) Mix_FreeMusic(bso);
	
	SDL_FreeSurface(sem1);
	SDL_FreeSurface(sem2);
	SDL_FreeSurface(sem3);
	SDL_FreeSurface(inicio);
	SDL_FreeSurface(final);
	SDL_FreeSurface(fondo);
	
	SDL_Quit();
	return 0;
}
