/*
	Well, another one of those ominous game_states ;-), meaning it
	again provides wonderful methods for update and draw. As you
	will clearly realize when reading this, it is a rather lazy class
	that does hardly any work at all, it checks for dead rectangles,
	revives them as appropiate, does the same for asteroids and keeps
	track of the rounds. Once one rectangle won 2 fights it is declared
	the victor by the public static properties and the update method
	returns the next state. All the interesting work is done in the
	classes used by this, which are(in no partricular order):
	
	scrolling_background - a rather boring class that does exactly what
	would be guessed from its name and is defined in include/bg.h
	
	announcement - not much more interesting, this is responsible for the
	wonderful text displays and announcements at the beginning of each
	round. defined in include/announcement.h
	
	rectangle - a user controlled rectangle on screen, which can shoot
	bullets, collect items and die with a very cheap particle affect
	accompaning its demise. Slightly more interesting and defined in
	include/rectangle.h
	
	asteroid - those mean stones flying around and exploding into smaller
	instances of themselfs, also responsible for dropping items on the screen.
	Not too boring, defined in include/asteroid.h
	
	The last two classes as well as the missiles used by rectangle are
	children of a base class called collision_obj, for they need to be
	checked for collisions and dealt with accordingly, which is done by
	the collision_mgr::update function defined in include/collision_mgr.h
	and you should better take a look at in order to understand them
	(remember, game_state_mgr called this function regularly).
	I will comment this next, so after reading the source
	(If you still dare to do so after all my rants and all the
	suboptimal implementations you have recently witnessed), follow me ;-).
*/
namespace rectangle_battle
{
	class versus_mode:public game_state
	{
		private:
		kos_gfx::pvr::texture tex[2];
		
		rectangle_battle::scrolling_background bg0,bg1,overlay;
		rectangle_battle::announcement round_announce[3];
		rectangle_battle::announcement ko_announce;
		
		rectangle_battle::rectangle red;
		rectangle_battle::rectangle blue;
		int player_1_id, player_2_id;
		
		rectangle_battle::asteroid asteroids[4];
		
		kos_gfx::pvr::texture_fragment victory_frame_red, victory_frame_blue;
		kos_gfx::pvr::texture_fragment victory_count_red, victory_count_blue;
		int victory_red, victory_blue;
		
		kos_gfx::sound::sfx::handle missile_sfx, missile_hit_sfx, explosion_sfx;
		
		rectangle_battle::pause::menu pause_menu;
		public:
		static bool blue_won, red_won;
		
		versus_mode(std::string tex_0, std::string tex_1, int p1_id=0, int p2_id=1):
		blue(300,440,40,40,10,10,0,0,255,p1_id),
		red(300,0,40,40,10,10,255,0,0,p2_id,rectangle_battle::DOWN)
		{
			player_1_id=p1_id;
			player_2_id=p2_id;
			
			victory_red=0;
			victory_blue=0;
			blue_won=false;
			red_won=false;
			
			tex[0]=kos_gfx::pvr::load_png_texture(tex_0);
			tex[1]=kos_gfx::pvr::load_png_texture(tex_1);
			
			victory_frame_red=kos_gfx::pvr::texture_fragment(tex[0],1024-120,0,120,94);
			victory_frame_blue=kos_gfx::pvr::texture_fragment(tex[0],1024-120,1024-94,120,94);
			victory_count_red=kos_gfx::pvr::texture_fragment(tex[0],881,2,17,14);
			victory_count_blue=kos_gfx::pvr::texture_fragment(tex[0],848,0,17,14);
			
			kos_gfx::pvr::texture_fragment bg0_tex(tex[0],0,0,640,480);
			kos_gfx::pvr::texture_fragment bg1_tex(tex[0],0,1024-480,640,480);
			kos_gfx::pvr::texture_fragment overlay_tex(tex[1],0,0,640,480);
			
			kos_gfx::pvr::texture_fragment round_txt(tex[0],644,0,173,58);
			kos_gfx::pvr::texture_fragment two_txt(tex[0],648,491,35,43);
			kos_gfx::pvr::texture_fragment one_txt(tex[0],648,551,14,50);
			kos_gfx::pvr::texture_fragment final_txt(tex[0],642,358,157,57);
			kos_gfx::pvr::texture_fragment ko_txt(tex[0],643,185,97,49);
			
			kos_gfx::pvr::texture_fragment asteroid0(tex[0],864,297,26,21);
			kos_gfx::pvr::texture_fragment asteroid1(tex[0],866,325,41,24);
			kos_gfx::pvr::texture_fragment asteroid2(tex[0],865,362,60,28);
			
			kos_gfx::pvr::texture_fragment atk_itm(tex[0],865,269,30,15);
			kos_gfx::pvr::texture_fragment barrier_itm(tex[0],866,242,30,15);
			
			kos_gfx::pvr::texture_fragment pause_bg(tex[1],0,1024-480,640,480);
			
			bg0=rectangle_battle::scrolling_background(bg0_tex,3,1.25);
			bg1=rectangle_battle::scrolling_background(bg1_tex,1.8,1);
			overlay=rectangle_battle::scrolling_background(overlay_tex,0,0);
			
			round_announce[0].create("/rd/sfx/first_round.wav",round_txt,one_txt);
			round_announce[1].create("/rd/sfx/second_round.wav",round_txt,two_txt);
			round_announce[2].create("/rd/sfx/final_round.wav",final_txt,round_txt);
			ko_announce.create("/rd/sfx/ko.wav",ko_txt);
			round_announce[1].done=true;
			round_announce[2].done=true;
			ko_announce.done=true;
			
			missile_sfx=kos_gfx::sound::sfx::load("/rd/sfx/missile.wav");
			missile_hit_sfx=kos_gfx::sound::sfx::load("/rd/sfx/missile_hit.wav");
			explosion_sfx=kos_gfx::sound::sfx::load("/rd/sfx/explosion.wav");
			red.set_sounds(missile_sfx,missile_hit_sfx);
			blue.set_sounds(missile_sfx,missile_hit_sfx);
			
			kos_gfx::pvr::texture_fragment missile_normal_red(tex[0],215,501,10,10);
			kos_gfx::pvr::texture_fragment missile_special_red(tex[0],364,504,10,10);
			kos_gfx::pvr::texture_fragment missile_normal_blue(tex[0],250,500,10,10);
			kos_gfx::pvr::texture_fragment missile_special_blue(tex[0],325,499,10,10);
			red.set_missile_textures(missile_normal_red,missile_special_red);
			blue.set_missile_textures(missile_normal_blue,missile_special_blue);
			
			
			for(int i=0;i<4;++i)
			{
				asteroids[i].create(asteroid0,asteroid1,asteroid2,atk_itm,barrier_itm,-300*i,kos_gfx::pvr::SCREEN_HEIGHT/2,4.5,0.1,2,-0.001-(double)((rand()%3)-2)/100.0f);
				asteroids[i].set_sound(explosion_sfx);
			};
			
			pause_menu=rectangle_battle::pause::menu(pause_bg);
			
		};
		
		~versus_mode()
		{
			kos_gfx::pvr::free_texture(tex[0]);
			kos_gfx::pvr::free_texture(tex[1]);
			
			kos_gfx::sound::sfx::stop_all();
			kos_gfx::sound::sfx::free(missile_sfx);
			kos_gfx::sound::sfx::free(missile_hit_sfx);
			kos_gfx::sound::sfx::free(explosion_sfx);
		};
		
		GAME_STATE update(GAME_STATE current_state, GAME_STATE next_state)
		{
			switch(pause_menu.update())
			{
				case rectangle_battle::pause::NOTHING:
				{
					return current_state;
				};
				case rectangle_battle::pause::QUIT:
				{
					return next_state;
				};
			};
			
			bg0.update();
			bg1.update();
			overlay.update();
			
			for(int i=0;i<3;++i)
			{
				if(!round_announce[i].done)
				{
					round_announce[i].update();
					return current_state;
				};
			};
			
			if(!ko_announce.done)
			{
				ko_announce.update();
				
				if(ko_announce.done)
				{
					if(victory_blue<2 && victory_red<2)
					{
						round_announce[victory_blue+victory_red].reset();
						red.reset();
						blue.reset();
					}
					else
					{
						if(victory_blue>1)
							blue_won=true;
						else
							red_won=true;
						return next_state;
					};
				};
			};
			
			red.update();
			blue.update();
			
			if((red.dead || blue.dead) && ko_announce.done)
			{
				if(red.dead && !blue.dead)
					++victory_blue;
				if(!red.dead && blue.dead)
					++victory_red;
				
				ko_announce.reset();
			};
			
			for(int i=0;i<4;++i)
			{
				if(asteroids[i].dead)
				{
					if(rand()%100==1)
						asteroids[i].revive();
				}
				else
					asteroids[i].update();
			};
			
			return current_state;
		};
		
		void draw()
		{
			bg0.draw();
			bg1.draw();
			
			red.draw();
			blue.draw();
			
			for(int i=0;i<4;++i)
			{
				asteroids[i].draw();
			};
			
			overlay.draw();
			
			kos_gfx::pvr::draw(victory_frame_red,kos_gfx::pvr::TITLE_SAFE_LEFT,kos_gfx::pvr::TITLE_SAFE_TOP);
			kos_gfx::pvr::draw(victory_frame_blue,kos_gfx::pvr::TITLE_SAFE_RIGHT-victory_frame_blue.w,kos_gfx::pvr::TITLE_SAFE_BOTTOM-victory_frame_blue.h);
			for(int i=0;i<victory_red;++i)
				kos_gfx::pvr::draw(victory_count_red,kos_gfx::pvr::TITLE_SAFE_LEFT+12+i*(victory_count_red.w+4),kos_gfx::pvr::TITLE_SAFE_TOP+20);
			for(int i=0;i<victory_blue;++i)
				kos_gfx::pvr::draw(victory_count_blue,kos_gfx::pvr::TITLE_SAFE_RIGHT-victory_count_blue.w-12-i*(victory_count_red.w+4),kos_gfx::pvr::TITLE_SAFE_BOTTOM-20-victory_count_blue.h);
	
			round_announce[0].draw();
			round_announce[1].draw();
			round_announce[2].draw();
			ko_announce.draw();
			
			pause_menu.draw();
		};
	};
	
	bool versus_mode::red_won, versus_mode::blue_won;
};
