namespace rectangle_battle
{
	const int DEFAULT_RESTORES=3;
	const int FIRST_POINTS_GOAL=20000;
	
	class survival_mode:public game_state
	{
		private:
		kos_gfx::pvr::texture tex[2];
		
		kos_gfx::pvr::texture_fragment panel, life_icon;
		
		rectangle_battle::announcement ko_announce;
		rectangle_battle::announcement get_ready_announce;
		rectangle_battle::announcement survive_announce;
		rectangle_battle::announcement game_over_announce;
		
		rectangle_battle::rectangle red;
		rectangle_battle::triangle triangles[3];
		rectangle_battle::falling_asteroid asteroids[10];
		
		rectangle_battle::pause::menu pause_menu;
		
		int available_restores;
		int points_goal; //If this number of points is reached, an extra life is granted ;-);
		
		rectangle_battle::scrolling_background bg0,bg1,overlay;
		
		kos_gfx::sound::sfx::handle missile_sfx, missile_hit_sfx, explosion_sfx;
		
		public:
		
		survival_mode(std::string tex_0, std::string tex_1, int player_id=0):
		red(300,kos_gfx::pvr::TITLE_SAFE_BOTTOM-40,40,40,10,10,255,0,0,player_id<4?player_id:0)
		{
			available_restores=DEFAULT_RESTORES;
			points_goal=FIRST_POINTS_GOAL;
			
			tex[0]=kos_gfx::pvr::load_png_texture(tex_0);
			tex[1]=kos_gfx::pvr::load_png_texture(tex_1);
			
			kos_gfx::pvr::texture_fragment bg0_tex(tex[0],0,0,640,480);
			kos_gfx::pvr::texture_fragment bg1_tex(tex[0],0,1024-480,640,480);
			kos_gfx::pvr::texture_fragment overlay_tex(tex[1],0,0,640,480);
			
			kos_gfx::pvr::texture_fragment ko_txt(tex[0],643,185,97,49);
			
			kos_gfx::pvr::texture_fragment asteroid0(tex[0],864,297,26,21);
			kos_gfx::pvr::texture_fragment asteroid1(tex[0],866,325,41,24);
			kos_gfx::pvr::texture_fragment asteroid2(tex[0],865,362,60,28);
			
			kos_gfx::pvr::texture_fragment atk_itm(tex[0],865,269,30,15);
			kos_gfx::pvr::texture_fragment barrier_itm(tex[0],866,242,30,15);
			
			kos_gfx::pvr::texture_fragment missile_normal_red(tex[0],215,501,10,10);
			kos_gfx::pvr::texture_fragment missile_special_red(tex[0],364,504,10,10);
			red.set_missile_textures(missile_normal_red,missile_special_red);
			
			kos_gfx::pvr::texture_fragment missile_normal_green(tex[0],301,499,10,10);
			kos_gfx::pvr::texture_fragment missile_special_green(tex[0],278,500,10,10);
			
			panel=kos_gfx::pvr::texture_fragment(tex[0],856,99,165,116);
			life_icon=kos_gfx::pvr::texture_fragment(tex[0],863,218,12,10);
			
			bg0=rectangle_battle::scrolling_background(bg0_tex,1.2,3.6);
			bg1=rectangle_battle::scrolling_background(bg1_tex,1.2,2.1);
			overlay=rectangle_battle::scrolling_background(overlay_tex,0,0);
			
			ko_announce.create("/rd/sfx/ko.wav",ko_txt);
			ko_announce.done=true;
			
			kos_gfx::pvr::texture_fragment game_txt(tex[0],643,303,163,52);
			kos_gfx::pvr::texture_fragment over_txt(tex[0],643,125,137,55);
			game_over_announce.create("/rd/sfx/game_over.wav",game_txt,over_txt);
			game_over_announce.done=true;
			
			kos_gfx::pvr::texture_fragment get_txt(tex[0],642,239,111,54);
			kos_gfx::pvr::texture_fragment ready_txt(tex[0],643,62,167,58);
			get_ready_announce.create("/rd/sfx/get_ready.wav",get_txt,ready_txt);
			get_ready_announce.done=false;
			
			kos_gfx::pvr::texture_fragment survive_txt(tex[0],644,424,236,55);
			survive_announce.create("/rd/sfx/survive.wav",survive_txt);
			survive_announce.done=true;
			
			missile_sfx=kos_gfx::sound::sfx::load("/rd/sfx/missile.wav");
			missile_hit_sfx=kos_gfx::sound::sfx::load("/rd/sfx/missile_hit.wav");
			explosion_sfx=kos_gfx::sound::sfx::load("/rd/sfx/explosion.wav");
			red.set_sounds(missile_sfx,missile_hit_sfx);
			
			for(int i=0;i<10;++i)
			{
				asteroids[i].create(asteroid0,asteroid1,asteroid2,atk_itm,barrier_itm,(i*kos_gfx::pvr::SCREEN_WIDTH)/10,-300*(i+1),1,4.5,2,-0.001-(double)((rand()%3)-2)/100.0f);
				asteroids[i].set_sound(explosion_sfx);
			};
			
			triangles[0].create(&red,50,-200,60,48,20,12,0,255,0,DOWN,180,100);
			triangles[1].create(&red,200,-200,60,48,20,12,0,255,0,DOWN,-180,100);
			triangles[2].create(&red,250,-200,60,48,20,12,0,255,0,DOWN,0,180);
			
			for(int i=0;i<3;++i)
			{
				triangles[i].set_missile_textures(missile_normal_green,missile_special_green);
				triangles[i].set_sounds(missile_sfx,missile_hit_sfx);
			};
				
			kos_gfx::pvr::texture_fragment pause_bg(tex[1],0,1024-480,640,480);
			pause_menu=rectangle_battle::pause::menu(pause_bg);
			
			kos_gfx::pvr::texture_fragment font_txr(tex[1],1024-256,1024-128,256,128);
			kos_gfx::pvr::font::init(font_txr,false);
		};
		
		~survival_mode()
		{
			kos_gfx::pvr::free_texture(tex[0]);
			kos_gfx::pvr::free_texture(tex[1]);
			
			kos_gfx::sound::sfx::free(missile_sfx);
			kos_gfx::sound::sfx::free(missile_hit_sfx);
			kos_gfx::sound::sfx::free(explosion_sfx);
		};
		
		GAME_STATE update(GAME_STATE current_state, GAME_STATE next_state)
		{
			if(!get_ready_announce.done)
			{
				get_ready_announce.update();
				if(get_ready_announce.done)
					survive_announce.reset();
				return current_state;
			};
			
			if(!survive_announce.done)
			{
				survive_announce.update();
				return current_state;
			};
			
			if(rectangle_battle::rectangle::points>points_goal && available_restores<DEFAULT_RESTORES)
			{
				++available_restores;
				points_goal*=2;
			};
			
			if(!game_over_announce.done)
			{
				game_over_announce.update();
				if(game_over_announce.done)
				{
					return next_state;
				};
				return current_state;
			};
			
			if(!ko_announce.done)
			{
				ko_announce.update();
				if(ko_announce.done)
				{
					--available_restores;
					if(available_restores<0)
					{
						game_over_announce.reset();
						return current_state;
					}
					else
						red.reset();
				};
			};
			
			switch(pause_menu.update())
			{
				case rectangle_battle::pause::NOTHING:
				{
					return current_state;
				};
				case rectangle_battle::pause::QUIT:
				{
					return next_state;
				};
			};
			
			red.update();
			if(red.dead && ko_announce.done)
				ko_announce.reset();
			
			for(int i=0;i<3;++i)
			{
				triangles[i].update();
				if(triangles[i].dead && rand()%100==1)
					triangles[i].revive();
			};
			
			for(int i=0;i<10;++i)
			{
				asteroids[i].update();
                if(asteroids[i].dead && rand()%100==1)
                {
                    asteroids[i].revive();
                };
			};
			
			bg0.update();
			bg1.update();
			overlay.update();
			
			return current_state;
		};
		
		void draw()
		{
			bg0.draw();
			bg1.draw();
			overlay.draw();
			
			red.draw();
			
			for(int i=0;i<10;++i)
			{
				asteroids[i].draw();
			};
			
			for(int i=0;i<3;++i)
			{
				triangles[i].draw();
			};
			
			kos_gfx::pvr::draw(panel,kos_gfx::pvr::TITLE_SAFE_LEFT,kos_gfx::pvr::TITLE_SAFE_TOP);
			kos_gfx::pvr::font::draw(rectangle_battle::rectangle::points,kos_gfx::pvr::TITLE_SAFE_LEFT+62,kos_gfx::pvr::TITLE_SAFE_TOP,16,16,-2);
			for(int i=0;i<available_restores;++i)
				kos_gfx::pvr::draw(life_icon,kos_gfx::pvr::TITLE_SAFE_LEFT+11+(i*(life_icon.w+2)),kos_gfx::pvr::TITLE_SAFE_TOP+37);
			
			ko_announce.draw();
			game_over_announce.draw();
			get_ready_announce.draw();
			survive_announce.draw();
			
			pause_menu.draw();
		};
	};
	
};
