/*
	You have been warned, for this is where the real overkill begins.
	A class for a rectangle which changes shape, what have i been thinking?
	Well, if you have no idea what the heck i am talking about you propably
	did not follow my instructions and should eighter read them again or
	dive into this code without my help(which is propably too unstructured
	and elaborated anyway). If, however you do, skip to line 173 now.
*/
namespace rectangle_battle
{
	//You have returned!
	//How unfortunate, for you will now witness one of the most foolish
	//uses of classes ever percieved by mankind. This is basically a rectangle
	//which can be drawn using its draw method and which changes its size with
	//a given speed whenever the update method is called.
	//Thats all there is to it and you may contine reading in line 46. 
	class menu_selector
	{
		private:
		double min_size, max_size, current_size;
		double anim_speed;
		kos_gfx::pvr::color col;
		public:
		menu_selector(double minsize, double maxsize, double animspeed, kos_gfx::pvr::color color)
		{
			min_size=minsize;
			max_size=maxsize;
			anim_speed=animspeed;
			col=color;
			
			current_size=min_size;
		};
		
		void update()
		{
            current_size += anim_speed;
            anim_speed *= current_size > max_size || current_size < min_size ? -1 : 1;
		};
		
		void draw(int pos_x, int pos_y)
		{
			kos_gfx::pvr::draw_rectangle(pos_x,pos_y,current_size,current_size,col);
		};
	};
	
	//Another rather simple piece of code, it simply draws a given image
	//at the center of the screen and a given text above it.
	//Used as a text box basically ;-) continue in line 55.
	void draw_information_window(kos_gfx::pvr::texture_fragment window, std::string txt)
	{
		kos_gfx::pvr::draw(window,kos_gfx::pvr::SCREEN_WIDTH/2-window.w/2,kos_gfx::pvr::SCREEN_HEIGHT/2-window.h/2);
		kos_gfx::pvr::font::draw(txt,kos_gfx::pvr::SCREEN_WIDTH/2-window.w/2+10,kos_gfx::pvr::SCREEN_HEIGHT/2-window.h/2+60,12,24,1);
	};
	
	//This class is rather self explanatory. It inherits from the already
	//mentioned abstract base class game_state, which implies it provieds
	//both, an update and a draw method.
	//There are two important things to notice here, first the rather weird
	//use of public static properties to tell the game state manager which
	//controller ports confirmed the selection and should be used to control
	//the rectangles in games and also the fact that it blatantly ignores the
	//second parameter of update(in all cases but quit) and simply returns the
	//players selection.
	//I wont explain this any further, however if there are unanswered questions
	//or you simply wish to express just how aweful this programm really is,
	//email me at fillius@2d-rp.de
	//If not, you should continue reading with the file include/versus_mode.h
	//(for this is the next one i will comment, there is no logical meaning
	//behind this choice, i just had to start somewhere ;-))
	//Thanks for reading this far;
	class main_menu:public game_state
	{
		private:
		kos_gfx::pvr::texture tex;
		kos_gfx::pvr::texture_fragment bg;
		kos_gfx::pvr::texture_fragment info_win;
		
		menu_selector selector;
		kos_gfx::math::vector2d<int> box_position;
		int box_entry_h;
		
		int selected_entry, num_entries;
		
		bool waiting_for_player;
		
		public:
		static int p1_id, p2_id;
		
		main_menu(std::string filename):
		selector(15,25,0.3,PVR_PACK_COLOR(1,0,1,1)),
		box_position(255,275),
		box_entry_h(27),num_entries(4)
		{
			tex=kos_gfx::pvr::load_png_texture(filename.c_str());
			bg=kos_gfx::pvr::texture_fragment(tex,0,0,640,480);
			info_win=kos_gfx::pvr::texture_fragment(tex,747,0,277,256);
			waiting_for_player=false;
			
			selected_entry=0;
			
			kos_gfx::pvr::font::init(kos_gfx::pvr::texture_fragment(tex,779,504,192,192));
			kos_gfx::input::emulate_dpad=true;
			
			p1_id=0;
			p2_id=1;
		};
		
		~main_menu()
		{
			kos_gfx::pvr::free_texture(tex);
			kos_gfx::input::emulate_dpad=false;
		};
		
		GAME_STATE update(GAME_STATE current_state, GAME_STATE next_state)
		{
			selector.update();
			
			if(waiting_for_player)
			{
				for(int i=0;i<4;++i)
				{
					if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_B)
					{
						waiting_for_player=false;
						return current_state;
					};
					
					if(i==p1_id)
						continue;
						
					if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_START)
					{
						p2_id=i;
						return VERSUS_MODE;
					};
				};
				return current_state;						
			};
			
			for(int i=0;i<4;++i)
			{
				if(kos_gfx::input::controllers[i].connected)
				{
					if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_A
					||kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_START)
					{
						p1_id=i;
						switch(selected_entry)
						{
							case 0:
								return SURVIVAL_MODE;
							case 1:
								waiting_for_player=true;
								return current_state;
							case 2:
								return HIGHSCORE_DISPLAY;
							default:
								return next_state;
						};
					};
					
					if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_DOWN)
					{
						++selected_entry;
					};
					if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_UP)
					{
						--selected_entry;
					};
				};
			};
			
			//VXVG6-TTFF9-PXHWP-XY986-3GHQD
			//you may return to the beginning now, or rather to line 11
			//this was just to hide that code from those fools who do not
			//read my instructions(sorry for being so mean a bastard ;-))
			
			selected_entry=selected_entry<0?num_entries-1:selected_entry;
			selected_entry%=num_entries;
					
			return current_state;
		};
		
		void draw()
		{
			kos_gfx::pvr::draw(bg,0,0);
			selector.draw(box_position.x,box_position.y+selected_entry*box_entry_h);
			if(waiting_for_player)
				rectangle_battle::draw_information_window(info_win,"Please press Player2\nStart Button\n(Or B to cancel)");
		};
	};
	
	int main_menu::p1_id, main_menu::p2_id;
};
