namespace kos_gfx
{
	struct rect
	{
		kos_gfx::Sint16 x,y;
		kos_gfx::Uint16 w,h;
	};
	
	namespace pvr
	{
		void draw_rectangle(int x, int y, int w, int h, uint32 col)
		{
			pvr_poly_hdr_t hdr;
			pvr_poly_cxt_t cxt;
			pvr_vertex_t vertex;
			
			pvr_poly_cxt_col(&cxt,kos_gfx::pvr::active_list_type);
			pvr_poly_compile(&hdr,&cxt);
			pvr_prim(&hdr,sizeof(hdr));
			
			vertex.flags=PVR_CMD_VERTEX;
			vertex.x=x;
			vertex.y=y;
			vertex.z=kos_gfx::pvr::z_val;
			vertex.u=0;
			vertex.v=0;
			vertex.argb=col;
			vertex.oargb=0;
			
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.x+=w;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.y+=h;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.x-=w;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.flags=PVR_CMD_VERTEX_EOL;
			vertex.y-=h;
			pvr_prim(&vertex,sizeof(vertex));
			
			++kos_gfx::pvr::z_val;
		}; 
		
		//with rotation ;-);
		void draw_rectangle(int x, int y, int w, int h, uint32 col, double radians)
		{
			kos_gfx::math::vector2d<> origin(x+w/2,y+h/2);
			kos_gfx::math::vector2d<> edge1(x,y), edge2(x+w,y), edge3(x+w,y+h), edge4(x,y+h);
			edge1.rotate(radians,origin);
			edge2.rotate(radians,origin);
			edge3.rotate(radians,origin);
			edge4.rotate(radians,origin);
			
			pvr_poly_hdr_t hdr;
			pvr_poly_cxt_t cxt;
			pvr_vertex_t vertex;
			
			pvr_poly_cxt_col(&cxt,kos_gfx::pvr::active_list_type);
			pvr_poly_compile(&hdr,&cxt);
			pvr_prim(&hdr,sizeof(hdr));
			
			vertex.flags=PVR_CMD_VERTEX;
			vertex.x=edge1.x;
			vertex.y=edge1.y;
			vertex.z=kos_gfx::pvr::z_val;
			vertex.u=0;
			vertex.v=0;
			vertex.argb=col;
			vertex.oargb=0;
			
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.x=edge2.x;
			vertex.y=edge2.y;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.x=edge3.x;
			vertex.y=edge3.y;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.x=edge4.x;
			vertex.y=edge4.y;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.flags=PVR_CMD_VERTEX_EOL;
			vertex.x=edge1.x;
			vertex.y=edge1.y;
			pvr_prim(&vertex,sizeof(vertex));
			
			++kos_gfx::pvr::z_val;
		};
		
		void draw_rectangle(int x, int y, int w, int h, Uint8 r, Uint8 g, Uint8 b, double radians=0)
		{
			if(radians==0)
				draw_rectangle(x,y,w,h,PVR_PACK_COLOR(1,((double)r)/255,((double)g)/255,((double)b)/255));
			else
				draw_rectangle(x,y,w,h,PVR_PACK_COLOR(1,((double)r)/255,((double)g)/255,((double)b)/255),radians);
		};

		void draw_rectangle(rect rec,Uint8 r, Uint8 g, Uint8 b, double radians=0)
		{
			if(radians==0)
				draw_rectangle(rec.x,rec.y,rec.w,rec.h,r,g,b);
			else
				draw_rectangle(rec.x,rec.y,rec.w,rec.h,r,g,b,radians);
		};

		void draw_triangle(int x1, int y1, int x2, int y2, int x3, int y3, kos_gfx::pvr::color col)
		{
			pvr_poly_hdr_t hdr;
			pvr_poly_cxt_t cxt;
			pvr_vertex_t vertex;
			
			pvr_poly_cxt_col(&cxt,kos_gfx::pvr::active_list_type);
			pvr_poly_compile(&hdr,&cxt);
			pvr_prim(&hdr,sizeof(hdr));
			
			vertex.flags=PVR_CMD_VERTEX;
			vertex.x=x1;
			vertex.y=y1;
			vertex.z=kos_gfx::pvr::z_val;
			vertex.u=0;
			vertex.v=0;
			vertex.argb=col;
			vertex.oargb=0;
			
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.x=x2;
			vertex.y=y2;
			pvr_prim(&vertex,sizeof(vertex));
			
			vertex.flags=PVR_CMD_VERTEX_EOL;
			vertex.x=x3;
			vertex.y=y3;
			pvr_prim(&vertex,sizeof(vertex));
			
			++kos_gfx::pvr::z_val;
		};
		
		void draw_triangle(int x1, int y1, int x2, int y2, int x3, int y3, Uint8 r, Uint8 g, Uint8 b)
		{
			draw_triangle(x1,y1,x2,y2,x3,y3,PVR_PACK_COLOR(1,((double)r)/255,((double)g)/255,((double)b)/255));
		};

	};
};
