namespace kos_gfx
{
	namespace math
	{
		const double PI=F_PI;
		
		template <class T=double>
		struct vector2d
		{
			T x,y;
			
			vector2d():x(0),y(0)
			{};
			
			vector2d(T val):x(val),y(val)
			{};
			
			vector2d(T vx, T vy):x(vx),y(vy)
			{};
			
			vector2d operator+(vector2d rhs)
			{
				return vector2d(this->x+rhs.x, this->y+rhs.y);
			};
			
			vector2d operator-(vector2d rhs)
			{
				return vector2d(this->x-rhs.x,this->y-rhs.y);
			};
			
			void operator+=(const vector2d &rhs)
			{
				this->x+=rhs.x;
				this->y+=rhs.y;
			};
			
			void operator-=(const vector2d &rhs)
			{
				this->x-=rhs.x;
				this->y-=rhs.y;
			};
			
			//no error checking ;-) shame on me ;-);
			void rotate(T radians)
			{
				T cos_rad=fcos(radians);
				T sin_rad=fsin(radians);
				T tmp=x;
				x=x*cos_rad-y*sin_rad;
				y=tmp*sin_rad+y*cos_rad;
			};
			
			void rotate(T radians,vector2d origin)
			{
				this->operator-=(origin);
				rotate(radians);
				this->operator+=(origin);
			};
		};
		
		template <class T>
		void rotate(T &x,T &y, T radians, T origin_x=0, T origin_y=0)
		{
			vector2d<T> vec(x,y), ori(origin_x,origin_y);
			vec.rotate(radians,ori);
			
			x=vec.x;
			y=vec.y;
		};
	};
};
