namespace rectangle_battle
{
	const int HIGHSCORE_SIZE=5;
	class highscore
	{
		private:
		std::string name[HIGHSCORE_SIZE];
		kos_gfx::Uint32 score[HIGHSCORE_SIZE];
		
		int used_vmu;
		
		public:
		highscore()
		{
			for(int i=0;i<HIGHSCORE_SIZE;++i)
			{
				name[i]="Triangle";
				score[i]=0;
			};
			
			used_vmu=-1;
		};
		
		bool load(int vmu_id=5)
		{
			vmu_id=vmu_id==5?used_vmu:vmu_id;
			if(vmu_id<0 || vmu_id>3)
				return false;
			
			kos_gfx::storage::init();
			kos_gfx::storage::vmu_file savefile("rectangle_battle_scores.sav");
			if(!kos_gfx::storage::vmus[vmu_id].load(savefile))
			{
				kos_gfx::storage::shutdown();
				return false;
			};
			
			for(int i=0;i<HIGHSCORE_SIZE;++i)
			{
				savefile.read(&score[i],sizeof(kos_gfx::Uint32));
				
				int string_size;
				savefile.read(&string_size,sizeof(kos_gfx::Uint32));
				
				std::string tmp_str;
				for(int j=0;j<string_size;++j)
				{
					char tmp;
					savefile.read(&tmp,1);
					tmp_str.push_back(tmp);
				};
				name[i].swap(tmp_str);
			};
			
			kos_gfx::storage::shutdown();
			
			used_vmu=vmu_id;
			return true;
		};
		
		bool save(int vmu_id=5)
		{
			vmu_id=vmu_id==5?used_vmu:vmu_id;
			if(vmu_id<0 || vmu_id>3)
				return false;
				
			kos_gfx::storage::init();
			kos_gfx::storage::vmu_file savefile("rectangle_battle_scores.sav");
			savefile.set_app_id("RectangleBattle");
			savefile.set_short_description("RectangleBattleSave");
			savefile.set_long_description("RectangleBattle Survival Highscores");
			
			for(int i=0;i<HIGHSCORE_SIZE;++i)
			{
				savefile.write(&score[i],sizeof(kos_gfx::Uint32));
				
				kos_gfx::Uint32 string_size=name[i].size();
				savefile.write(&string_size,sizeof(kos_gfx::Uint32));
				savefile.write((void*)name[i].c_str(),string_size);
			};
			bool success=kos_gfx::storage::vmus[vmu_id].save(savefile);
			
			kos_gfx::storage::shutdown();
			if(success)
				used_vmu=vmu_id;
				
			return success;
		};
		
		bool is_highscore(kos_gfx::Uint32 new_score)
		{
			return new_score>score[HIGHSCORE_SIZE-1];
		};
		
		void insert_new(kos_gfx::Uint32 new_score, std::string new_name)
		{
			if(!is_highscore(new_score))
				return;
			
			int id=0;
			for(int i=0;i<HIGHSCORE_SIZE;++i)
			{
				if(new_score>score[i])
				{
					id=i;
					break;
				};
			};

			for(int i=HIGHSCORE_SIZE-1;i>id;--i)
			{
				score[i]=score[i-1];
				name[i]=name[i-1];
			};
			score[id]=new_score;
			name[id]=new_name;
		};
		
		void render(int pos_x, int pos_y, int width, kos_gfx::pvr::color col=PVR_PACK_COLOR(1,1,1,1))
		{
			//will fail horribly if HIGHSCORE_SIZE>8 ;-);
			for(int i=0;i<HIGHSCORE_SIZE;++i)
			{
				std::string number="";
				number+=(char)('1'+i); //that is the reason ;-);
				number+='.';
								
				kos_gfx::pvr::font::draw(number,pos_x,pos_y,12,24,1,false,col);
				kos_gfx::pvr::font::draw(name[i],pos_x+25,pos_y,12,24,1,false,col);
				kos_gfx::pvr::font::draw(score[i],pos_x+width,pos_y,12,24,1,false,true,col);
				
				pos_y+=48;
			};
		};
	};
};
