namespace rectangle_battle
{
	class progress_bar
	{
		private:
		int const *value;
		
		unsigned int max_value,max_w;
		unsigned int h;
		
		kos_gfx::pvr::color col;
		
		public:
		progress_bar(int const *val, int max, int width, int height, kos_gfx::pvr::color color):value(val)
		{
			max_value=max;
			max_w=width;
			h=height;
			col=color;
		};
		
		void draw(int x, int y)
		{
			kos_gfx::pvr::draw_rectangle(x,y,max_w*(*value)/max_value,h,col);
		};
	};

	namespace pause
	{
		enum SELECTION
		{
			NOTHING,
			RESUME,
			QUIT
		};
	
		class menu
		{
			private:
			kos_gfx::pvr::texture_fragment bg;
			menu_selector selector;
			rectangle_battle::progress_bar sfx_bar, bgm_bar;
			
			kos_gfx::math::vector2d<> sel_pos;
			int sel_size;
		
			bool active;
			
			int selected_entry, num_entries;
			public:
			menu(kos_gfx::pvr::texture_fragment bg_tex=kos_gfx::pvr::texture_fragment()):
			selector(10,20,0.3,PVR_PACK_COLOR(1,0,1,1)),
			sfx_bar(&kos_gfx::sound::sfx::VOLUME,kos_gfx::sound::sfx::MAX_VOLUME,80,20,PVR_PACK_COLOR(1,0,1,0)),
			bgm_bar(&kos_gfx::sound::music::VOLUME,kos_gfx::sound::music::MAX_VOLUME,80,20,PVR_PACK_COLOR(1,0,1,0))
			{
				active=false;
				bg=bg_tex;
				
				sel_pos.x=227;
				sel_pos.y=136;
				sel_size=28;
				num_entries=4;
			};
		
			SELECTION update()
			{
				if(active)
				{
					selector.update();
			
					for(int i=0;i<4;++i)
					{
						if(kos_gfx::input::controllers[i].connected)
						{
							if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_A
							||kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_START)
							{
								switch(selected_entry)
								{
									case 0:
									{
										kos_gfx::input::emulate_dpad=false;
										kos_gfx::input::reset_all();
										active=false;
										return RESUME;
									};
									case 3:
									{
										return QUIT;
									};
								};
							};
					
							if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_DOWN)
							{
								++selected_entry;
							};
							if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_UP)
							{
								--selected_entry;
							};
							
							if(kos_gfx::input::controllers[i].buttons&kos_gfx::input::BUTTON_RIGHT)
							{
								if(selected_entry==1)
								{
									kos_gfx::sound::music::set_volume(kos_gfx::sound::music::VOLUME+1);
								}
								else if(selected_entry==2)
								{
									if(kos_gfx::sound::sfx::VOLUME<kos_gfx::sound::sfx::MAX_VOLUME)
										++kos_gfx::sound::sfx::VOLUME;
								};
							};
							if(kos_gfx::input::controllers[i].buttons&kos_gfx::input::BUTTON_LEFT)
							{
								if(selected_entry==1)
								{
									kos_gfx::sound::music::set_volume(kos_gfx::sound::music::VOLUME-1);
								}
								else if(selected_entry==2)
								{
									if(kos_gfx::sound::sfx::VOLUME>0)
										--kos_gfx::sound::sfx::VOLUME;
								};
							};
						};
					};
			
					selected_entry=selected_entry<0?num_entries-1:selected_entry;
					selected_entry%=num_entries;
					return NOTHING;
				}
				else
				{
					for(int i=0;i<4;++i)
					{
						if(kos_gfx::input::controllers[i].connected && kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_START)
						{
							active=true;
							kos_gfx::input::emulate_dpad=true;
							selected_entry=0;
							return NOTHING;
						};
					};
				};
				return RESUME;
			};
		
			void draw()
			{
				if(active)
				{
					kos_gfx::pvr::draw(bg,0,0);
					selector.draw(sel_pos.x,sel_pos.y+selected_entry*sel_size);
					
					bgm_bar.draw(sel_pos.x+85,sel_pos.y+sel_size);
					sfx_bar.draw(sel_pos.x+85,sel_pos.y+2*sel_size);
				};
			};
		};
		
	};
};
