/*
	really simple class which moves with a given velocity whenever update()
	is called and does a certain damage when hitting some target.
	It is drawn as a nicely rotating image and shows some effect that
	attempts to look like an explosion upon dying. Nothing to explain here,
	i will continue with asteroid(you guessed it: include/asteroid.h);
*/
namespace rectangle_battle
{
	class basic_missile:public rectangle_battle::collision_mgr::collision_obj
	{
		private:
		kos_gfx::pvr::texture_fragment tex;
		
		double rot, rot_speed;
		
		int death_count, death_frame_count;
		rectangle_battle::collision_mgr::element collision_elem;
		
		public:
		
		basic_missile(kos_gfx::pvr::texture_fragment t, double pos_x=0, double pos_y=0,int mw=0, int mh=0,double vel_x=0, double vel_y=0, double rotation_speed=0.1, double str=1):
		tex(t),rot(0),rot_speed(rotation_speed)
		{
			dying=false;
			dead=false;
			death_count=0;
			death_frame_count=6;
			position=kos_gfx::math::vector2d<>(pos_x,pos_y);
			velocity=kos_gfx::math::vector2d<>(vel_x,vel_y);
			w=mw;
			h=mh;
			dmg=str;
			
			collision_elem=rectangle_battle::collision_mgr::register_missile(this);
		};
		
		~basic_missile()
		{
			rectangle_battle::collision_mgr::unregister_missile(collision_elem);
		};
		
		void hit(collision_obj *other)
		{
			dying=true;
		};
		
		void update()
		{
			if(dead)
				return;
			
			if(!dying)
				position+=velocity;
			else
			{
				++death_count;
				if(death_count>=death_frame_count)
					dead=true;
			};
			
			rot+=rot_speed;
			
			if((position.x+tex.w<0 && velocity.x<0) ||
			(position.y+tex.h<0 && velocity.y<0) ||
			(position.x>kos_gfx::pvr::SCREEN_WIDTH && velocity.x>0) ||
			(position.y>kos_gfx::pvr::SCREEN_HEIGHT && velocity.y>0))
				dead=true;
			
			double sign=rot_speed>0?1:-1;
			rot=rot*sign>2*kos_gfx::math::PI?rot-sign*2*kos_gfx::math::PI:rot;
		};
		
		void draw_explosion_particles()
		{
			if(tex.tex.tex==NULL)
				kos_gfx::pvr::draw_rectangle(position.x,position.y,death_count*w,death_count*h,PVR_PACK_COLOR(1,110.0f/255,110.0f/255,110.0f/255),rot);
			else
			{
				int particle_row_num = 30, particle_column_count=4;
				for(int j=-particle_column_count/2;j<particle_column_count/2;++j)
				{
					kos_gfx::math::vector2d<> rot_vec=velocity;
					rot_vec.rotate(0.2*j);
					for(int i=1;i<=particle_row_num*(((double)death_count/(double)death_frame_count));++i)
					{
						if((w*0.9)/i<1) continue;
						kos_gfx::pvr::draw(tex,position.x-i*3*rot_vec.x,position.y-i*2*rot_vec.y,(w*0.9f)/i,(h*0.9f)/i,rot);
					};
				};
			};		
		};
		
		void draw()
		{
			if(!dead && !dying)
			{
				if((tex.tex.tex)!=NULL)
					kos_gfx::pvr::draw(tex,position.x,position.y,w,h,rot);
				else
					kos_gfx::pvr::draw_rectangle(position.x,position.y,w,h,PVR_PACK_COLOR(1,110.0f/255,110.0f/255,110.0f/255),rot);
			}
			else
			{
				draw_explosion_particles();
			};
		};
	};
};
