/*
	Maybe I will use something else than ogg in the next game, but for now, due to simplicity ;-);
	ogg-vorbis seems to really slow everything down, whatever ;-);
	This is basically a very simple wrapper, not really useful ;-);
*/

#include <dc/sound/sound.h>
#include <oggvorbis/sndoggvorbis.h>

namespace kos_gfx
{
	namespace sound
	{
		void init()
		{
			snd_init();
		};
		
		void shutdown()
		{
			snd_shutdown();
		};
		
		namespace music
		{
			const int MAX_VOLUME=255;
			int VOLUME=MAX_VOLUME;
			
			void init()
			{
				sndoggvorbis_init();
			};
			
			void shutdown()
			{
				sndoggvorbis_shutdown();
			};
			
			void play(std::string filename,bool loop=true)
			{
				if(sndoggvorbis_isplaying())
					sndoggvorbis_stop();
					
					sndoggvorbis_start(filename.c_str(),loop?1:0);
			};
			
			void stop()
			{
				sndoggvorbis_stop();
			};
			
			void set_volume(int new_volume)
			{
				VOLUME=new_volume>0?new_volume<kos_gfx::sound::music::MAX_VOLUME?new_volume:kos_gfx::sound::music::MAX_VOLUME:0;
				sndoggvorbis_volume(kos_gfx::sound::music::VOLUME);
			};
		};
		
		namespace sfx
		{
			const int MAX_VOLUME=255;
			int VOLUME=MAX_VOLUME;
			typedef sfxhnd_t handle;
			
			handle load(std::string filename)
			{
				return snd_sfx_load(filename.c_str());
			};
			
			void free(handle sfxhnd)
			{
				snd_sfx_unload(sfxhnd);
			};
			
			void free_all()
			{
				snd_sfx_unload_all();
			};
			
			void play(handle sfxhnd)
			{
				snd_sfx_play(sfxhnd,VOLUME,128);
			};
			
			void stop_all()
			{
				snd_sfx_stop_all();
			};
		};
	};
};
