namespace rectangle_battle
{
	class highscore_display:public game_state
	{
		private:
		kos_gfx::pvr::texture tex;
		kos_gfx::pvr::texture_fragment bg;
		
		rectangle_battle::highscore *scores;
		
		public:
		highscore_display(std::string filename,rectangle_battle::highscore *highscores):
		scores(highscores)
		{
			tex=kos_gfx::pvr::load_png_texture(filename);
			
			bg=kos_gfx::pvr::texture_fragment(tex,0,1024-480,640,480);
			
			kos_gfx::pvr::font::init(kos_gfx::pvr::texture_fragment(tex,779,504,192,192));
		};
		
		~highscore_display()
		{
			kos_gfx::pvr::font::shutdown();
			kos_gfx::pvr::free_texture(tex);
		};
		
		GAME_STATE update(GAME_STATE current_state, GAME_STATE next_state)
		{
			for(int i=0;i<4;++i)
			{
				if(kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_A
				||kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_B
				||kos_gfx::input::controllers[i].clicked_buttons&kos_gfx::input::BUTTON_START)
					return next_state;
			};
			return current_state;
		};
		
		void draw()
		{
			kos_gfx::pvr::draw(bg,0,0);
			scores->render(322,100,258);
		};
	};
};
