namespace rectangle_battle
{
	class scrolling_background
	{
		private:
		kos_gfx::pvr::texture_fragment img;
		double speed_x, speed_y;
		double pos_x, pos_y;
	
		public:
		scrolling_background()
		{};
		
		scrolling_background(kos_gfx::pvr::texture_fragment tex,double sx, double sy):
		img(tex),speed_x(sx),speed_y(sy)
		{
			pos_x=0;
			pos_y=0;
		};
		
		void update()
		{
			pos_x+=speed_x;
			pos_y+=speed_y;
			pos_x=pos_x>kos_gfx::pvr::SCREEN_WIDTH?
				pos_x-kos_gfx::pvr::SCREEN_WIDTH:pos_x<-kos_gfx::pvr::SCREEN_WIDTH?
					pos_x+kos_gfx::pvr::SCREEN_WIDTH:pos_x;
			pos_y=pos_y>kos_gfx::pvr::SCREEN_HEIGHT?
				pos_y-kos_gfx::pvr::SCREEN_HEIGHT:pos_y<-kos_gfx::pvr::SCREEN_HEIGHT?
					pos_y+kos_gfx::pvr::SCREEN_HEIGHT:pos_y;
		};
		
		void draw()
		{
			int rx=pos_x,ry=pos_y;
			kos_gfx::pvr::draw(img,rx,ry);
			kos_gfx::pvr::draw(img,rx-(kos_gfx::pvr::SCREEN_WIDTH*(speed_x>0?1:-1)),ry);
			kos_gfx::pvr::draw(img,rx,ry-(kos_gfx::pvr::SCREEN_HEIGHT*(speed_y>0?1:-1)));
			kos_gfx::pvr::draw(img,rx-(kos_gfx::pvr::SCREEN_WIDTH*(speed_x>0?1:-1)),ry-(kos_gfx::pvr::SCREEN_HEIGHT*(speed_y>0?1:-1)));
		};
	};
};
