namespace rectangle_battle
{
	class announcement
	{
		private:
		kos_gfx::pvr::texture_fragment txt[2];
		kos_gfx::sound::sfx::handle sfx_handle;
		kos_gfx::Uint32 number_of_frames, frame_counter, wait_counter;
		
		public:
		bool done;
		
		announcement()
		{
			create();
		};
		
		void create(std::string sfx_filename="",kos_gfx::pvr::texture_fragment txt0=kos_gfx::pvr::texture_fragment(), kos_gfx::pvr::texture_fragment txt1=kos_gfx::pvr::texture_fragment(), kos_gfx::Uint32 frame_num=90)
		{
			if(sfx_filename!="")
				sfx_handle=kos_gfx::sound::sfx::load(sfx_filename);
			else
				sfx_handle=0;
			
			number_of_frames=frame_num;
			
			txt[0]=txt0;
			txt[1]=txt1;
			
			reset();
		};
		
		~announcement()
		{
			if(sfx_handle!=0)
				kos_gfx::sound::sfx::free(sfx_handle);
		};
		
		void reset()
		{
			frame_counter=0;
			wait_counter=0;
			done=false;
		};
		
		void update()
		{
			if(frame_counter==0 && sfx_handle!=0 && !done)
				kos_gfx::sound::sfx::play(sfx_handle);
				
			if(frame_counter<number_of_frames)
				++frame_counter;
			else
				++wait_counter;
				
			if(wait_counter>number_of_frames)
				done=true;
		};
		
		void draw()
		{
			if(done)
				return;
				
            double fact=3.0-2*((double)frame_counter/(double)number_of_frames);
            
            if(txt[1].tex.tex==NULL)
            	kos_gfx::pvr::draw(txt[0],kos_gfx::pvr::SCREEN_WIDTH/2-(txt[0].w*fact)/2,
            		kos_gfx::pvr::SCREEN_HEIGHT/2-(txt[0].h*fact)/2,txt[0].w*fact,txt[0].h*fact);
            else
            {
				kos_gfx::pvr::draw(txt[0],kos_gfx::pvr::SCREEN_WIDTH/2-3*(txt[0].w*fact)/4,
					kos_gfx::pvr::SCREEN_HEIGHT/2-(txt[0].h*fact),txt[0].w*fact,txt[0].h*fact);
				kos_gfx::pvr::draw(txt[1],fact*((2*kos_gfx::pvr::SCREEN_WIDTH/3)-(txt[1].w/2)),
					kos_gfx::pvr::SCREEN_HEIGHT/2,txt[1].w*fact,txt[1].h*fact);
			};
		};
		
	};
};
