#include <vector>
#include <string>
#include <fstream>
#include <cstdlib>
#include "dc_buttons.h"
	//#include <assert.h>
#include <SDL/SDL.h>
#include <SDL_image.h>
//#include <SDL_mixer.h>
#include <dc/sound/stream.h>
#include <dc/sound/sound.h>
#include <dc/sound/sfxmgr.h>
#include <oggvorbis/sndoggvorbis.h>

#include <SDL_dreamcast.h>

#include <SDL_gfxPrimitives.h>
#include "SDL_gfx_5x7_fnt.h"

#include "include/own_blit.h"
#include "include/load_image.h"

#include "include/vmu_icon.h"
#include "include/rumble_pack.h"

#include "include/jr_globals.h"
#include "jr_cutscene.h"
#include "jr_map.h"
#include "jr_player.h"

#include "jr_dialog.h"
#include "jr_menu.h"

//void play_intro(SDL_Surface *buffer);

int main(int argc, char *argv[])
{
	//snd_init();

	snd_stream_init();
	sndoggvorbis_init();

	SDL_DC_ShowAskHz(SDL_bool(false));
	vmu_set_icon(vmu_icon_xpm);
	gfxPrimitivesSetFont(& SDL_gfx_font_5x7_fnt,5,7);

	SDL_Init(SDL_INIT_VIDEO);

	init_button_mapping();
	init_rumble_pack();

	SDL_Surface *screen=SDL_SetVideoMode(320,240,16,/*SDL_SWSURFACE*/SDL_HWSURFACE | SDL_DOUBLEBUF);
	SDL_ShowCursor(false);

	play_2d_rp_intro(screen);

	menu(screen);

	sndoggvorbis_stop();
	return 0;
};


/*void play_intro(SDL_Surface *buffer)
{
	//Mix_Chunk *intro_sound=Mix_LoadWAV("/cd/sounds/intro_bgm.wav");
	sfxhnd_t intro_sound=snd_sfx_load("/cd/sounds/intro_bgm.wav");
	//int channel=Mix_PlayChannel(-1,intro_sound,0);
	snd_sfx_play(intro_sound,SOUND_VOLUME,0);
	SDL_Surface *intro_bg=LoadImage("images/intro_bg.png");
	for(int i=0;i<256;i+=3)
	{
		SDL_SetAlpha(intro_bg,SDL_SRCALPHA,i);
		SDL_FillRect(buffer,NULL,SDL_MapRGB(buffer->format,255,255,255));
		BlitSurface(intro_bg,0,0,intro_bg->w,intro_bg->h,buffer,0,0);
		SDL_Flip(buffer);
	};
	SDL_Delay(50);
	snd_sfx_stop_all();
	snd_sfx_unload(intro_sound);
	SDL_FreeSurface(intro_bg);
};
*/
