#include <kos.h>

cont_cond_t controller_state;
uint8 controller_handle;

void exit_buttons()
{
	//cont_shutdown();
};

void init_button_mapping()
{
	//cont_init();
	controller_handle=maple_first_controller();
};

enum {
	BTN_A = 1<<0,
	BTN_B = 1<<1,
	BTN_X = 1<<2,
	BTN_Y = 1<<3,
	BTN_L = 1<<10,
	BTN_R = 1<<11,
	BTN_MENU = 1<<4,
	BTN_SELECT = 1<<5,
	BTN_LEFT = 1<<6,
	BTN_RIGHT = 1<<7,
	BTN_UP = 1<<8,
	BTN_DOWN = 1<<9,
	BTN_VOLUP = 0,
	BTN_VOLDOWN = 0
};

int get_button_state()
{
	int control_state=0;
	cont_get_cond(controller_handle, &controller_state);
	if(!(controller_state.buttons & CONT_X))
	{
		control_state|= BTN_A;
	};
	if(!(controller_state.buttons & CONT_Y))
	{
		control_state|= BTN_Y;
	};
	if(!(controller_state.buttons & CONT_A))
	{
		control_state|= BTN_X;
	};
	if(!(controller_state.buttons & CONT_B))
	{
		control_state|= BTN_B;
	};
	if(!(controller_state.buttons & CONT_START))
	{
		control_state|= BTN_MENU;
	};

	if(!(controller_state.buttons & CONT_DPAD_LEFT))
	{
		control_state|= BTN_LEFT;
	};
	if(!(controller_state.buttons & CONT_DPAD_RIGHT))
	{
		control_state|= BTN_RIGHT;
	};
	if(!(controller_state.buttons & CONT_DPAD_UP))
	{
		control_state|= BTN_UP;
	};
	if(!(controller_state.buttons & CONT_DPAD_DOWN))
	{
		control_state|= BTN_DOWN;
	};
	if(controller_state.rtrig!=0)
	{
		control_state|= BTN_R;
	};
	if(controller_state.ltrig!=0)
	{
		control_state|= BTN_L;
	};
	return control_state;
}
