#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "SDL.h"
#include "SFont.h"

#include "SDL_image.h"

SDL_Surface *screen;

void init_SDL()
{
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
		fprintf(stderr,
			"Couldn't initialize SDL: %s\n", SDL_GetError());
		exit(1);
	}
	atexit(SDL_Quit);			/* Clean up on exit */

	/* Initialize the display */
	screen = SDL_SetVideoMode(640, 480, 0, 0);
	if ( screen == NULL ) {
		fprintf(stderr, "Couldn't set %dx%dx%d video mode: %s\n",
					640, 480, 16, SDL_GetError());
		exit(1);
	}
	
	/* Set the window manager title bar */
	SDL_WM_SetCaption("SFont Test", "SFont");
}

int main(int argc, char *argv[])
{
	char text[200]="";
	SDL_Surface *Font;

	init_SDL();

	// Load the font - You don't have to use the IMGlib for this
	Font=IMG_Load("24P_Copperplate_Blue.png");
	// Prepare the font for use
	InitFont(Font);
	
	// a simple text blit to (0/0)
	PutString(screen, 0, 0, "Top Left");
	// License Info...
	PutString(screen, 60, 120, "SFont by Karl Bartel is GPL'ed!");
	// show some special chars
	PutString(screen, 300, 260, "@--~!%&'_*,.:;");
	// demonstrates the use of TextWidth
	PutString(screen, 640-TextWidth("Bottom Right!"),480-Font->h,"Bottom Right!");
	// Update the screen
	SDL_UpdateRect(screen, 0, 0, 0, 0);
	// Let the user modify the text
	SFont_Input(screen, 260, 350, 280, text);
	
	// Bye
	exit(0);
}
