#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "SDL.h"
#include "SFont.h"

#include "SDL_image.h"

SDL_Surface *screen;

void init_SDL()
{
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
		fprintf(stderr,
			"Couldn't initialize SDL: %s\n", SDL_GetError());
		exit(1);
	}
	atexit(SDL_Quit);			/* Clean up on exit */

	/* Initialize the display */
	screen = SDL_SetVideoMode(640, 480, 0, 16);
	if ( screen == NULL ) {
		fprintf(stderr, "Couldn't set %dx%dx%d video mode: %s\n",
					640, 480, 16, SDL_GetError());
		exit(1);
	}
	
	/* Set the window manager title bar */
	SDL_WM_SetCaption("SFont Font Viewer", "SFontViewer");
}

int main(int argc, char *argv[])
{
	SDL_Surface *Font;
	SDL_Event event;
	char text[100];

	init_SDL();

	if (argv[1]) {
    	    sprintf(text,"%s",argv[1]);
	    // Load the font - You don't have to use the IMGlib for this
	    Font=IMG_Load(argv[1]);
	} else {
	    puts("SFont Font Viewer");
	    puts("Usage:\n");
	    puts("SFontViewer FONTFILE [TEXTTOPRINT] [namepic]\n");
	    exit(0);
	}
	// Prepare the font for use
	InitFont(Font);
	
	if (argv[2]) {
	    if (strcmp(argv[2],"namepic")==0) {
		SDL_Surface *surf;
		
		strrchr(text,'.')[0]='\0';
		PutString(surf,0,0,text);
		sprintf(text,"%s.bmp",text);
		SDL_SaveBMP(surf,text);
	    } else {
		// a simple text blit to (0/0)
    		sprintf(text,"%s",argv[2]);
		PutString(screen,0,0,text);
	    }
	} else {
	    PutString(screen,0,0,text);
	    XCenteredString(screen,60,"SFont Font Viewer");
	    XCenteredString(screen,300,"This text is for testing purposes.");
	    XCenteredString(screen,360,"This one, too <>%&-~|/_#+");
	}

        // Update the screen
	SDL_UpdateRect(screen, 0, 0, 0, 0);
	// Let the user time to look at the font
	SDL_EventState( SDL_KEYUP, SDL_IGNORE );
	SDL_EventState( SDL_ACTIVEEVENT, SDL_IGNORE );
	SDL_EventState( SDL_MOUSEMOTION, SDL_IGNORE );
	SDL_EventState( SDL_SYSWMEVENT, SDL_IGNORE );
	SDL_WaitEvent(&event);
	// Bye
	exit(0);
}
