// Copyright (C) 2002 Vincent Bherer-Roy
// 
// YaSFCave is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// YaSFCave is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Map.h

#include "SDL_video.h"

class Map
{
public:
	Map(SDL_Surface* _pSurface, int _w, int _h);
	~Map();

	Uint32 Update(bool _bClick);
	void Blit(SDL_Surface* _pSurface, SDL_Rect* _pDstRect);

	Uint32 GetScore() const { return muiFrame; };

private:

	void AddColumn();
	bool MoveWorm(bool _bClick);
	void DrawWorm();

	struct CollideInfo
	{
		int tunnelBegin;
		int tunnelEnd;
		int obstacleBegin;
		int obstacleEnd;
	};

	Uint32			muiFrame;

	int				mOffsetX;
	int				mLastColumnX;
	int				mWormX;

	float			mfWormY;
	int				mNextWormY;
	int				mLastWormY;
	float			mfSpeedY;
	float			mfYAcc;

	int				mW;
	int				mH;

	float			mfTunnelBegin;
	float			mfIncTunnelBegin;
	float			mfNextTunnelBegin;

	int				mTunnelHeight;
	
	CollideInfo*	mpCollideInfos;
	SDL_Surface*	mpSurface;

	Uint32			mWormColor;
	Uint32			mBackColor;
	Uint32			mBorderColor;
};

