// Copyright (C) 2002 Vincent Bherer-Roy
// 
// YaSFCave is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// YaSFCave is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Game.h

#ifndef DREAMCAST
	#include "SDL_video.h"
#endif
#include "SFont.h"

class Map;

class Game
{
public:
	Game();
	~Game();

	bool Update(bool _bClick);

	void DrawGame(bool _bRefresh = false);
	void DrawGameOver();
	void DrawPause();
	void DrawStart();
	void DrawAbout1();
	void DrawAbout2();
	
	void NewGame();
	void EndGame();

	void ResetHighScore();

private:

	void DrawBorder();

	SDL_Surface* mpSurface;

	SDL_Rect mWinRect;
	SDL_Rect mViewRect;

	Uint32 mBorderColor;
	Uint32 mBackColor;

	SFont_FontInfo mFontBlue;
	SFont_FontInfo mFontRed;

	Map* mpMap;

	Uint32 muiHighScore;
	
	Uint32 muiSpacing;
};

