/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 * Program WebSite: http://methane.sourceforge.net/index.html              *
 * Project Email: rombust@postmaster.co.uk                                 *
 *                                                                         *
 ***************************************************************************/

//------------------------------------------------------------------------------
// The AROS main document header file
//------------------------------------------------------------------------------

#ifndef _doc_h
#define _doc_h 1

#include "game.h"
#include "target.h"

#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

#ifndef MAX
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))
#define MIN(a,b)    (((a) < (b)) ? (a) : (b))
#endif

//#define AROS_SCREEN_W 640
//#define AROS_SCREEN_H 512

#define AROS_BUTTON_UP              (0)
#define AROS_BUTTON_DOWN            (4)
#define AROS_BUTTON_LEFT            (2)
#define AROS_BUTTON_RIGHT           (6)
#define AROS_BUTTON_UPLEFT          (1)
#define AROS_BUTTON_UPRIGHT         (7)
#define AROS_BUTTON_DOWNLEFT        (3)
#define AROS_BUTTON_DOWNRIGHT       (5)
#define AROS_BUTTON_CLICK           (18)
#define AROS_BUTTON_1               (14)


#ifdef METHANE_MIKMOD
class CMikModDrv;
#endif

class CMethDoc
{

public:
	CMethDoc();
	~CMethDoc();

	void InitGame(void);
	void StartGame(void);
	void MainLoop(void *screen_ptr);
	void RedrawMainView( int pal_change_flag );
	void PlayModule(int id);
	void StopModule(void);
	void PlaySample(int id, int pos, int rate);
	void RemoveSoundDriver(void);
	void InitSoundDriver(void);
	void UpdateModule(int id);
	void SaveScores(void);
	void LoadScores(void);

private:
	void DrawScreen( void *screen_ptr );
private:
#ifdef METHANE_MIKMOD
	CMikModDrv	*m_pMikModDrv;
#endif

public:
	CGameTarget	m_GameTarget;

};

#endif


