//
// s3mlib.c 
//
// (C)2001 Wauters Kris
//
// For more information, check out http://www.snoozys-dc-stuff.be.tf
//

// The good ol' 2ndmix example that just won't die ^_^
// 2010 - Taken from 2ndmix.c example in KOS

#include <kos.h>
#include "s3mlib.h"
#include "s3mplay.h"


//--- this function will load and play an S3M file ---
int s3m_play(char *fn)
{
	int idx, r;
	uint32 fd;
	unsigned char buffer[2048];

	spu_disable();

	fd = fs_open(fn, O_RDONLY);
	if (fd == 0) {
		return -1;
	}
	
	idx = 0x10000;
	/* Load 2048 bytes at a time */
	while ( (r=fs_read(fd, buffer, 2048)) > 0) {
		spu_memload(idx, buffer, r);
		idx += r;
	}
	fs_close(fd);

	spu_memload(0, s3mplay, sizeof(s3mplay));
	
	spu_enable();
	return 0;
}
