//
// my own implementation on top off the MAPLE from libdream
// (much easier to use, LOL)
//
// (C)2001 Wauters Kris
//
// For more information, check out http://www.snoozys-dc-stuff.be.tf
//
// Now from KOS - 2010 Indiket (and yeah, LOL!)

#include <kos.h>
#include "glyphix_maple.h"

#define RGB565(r, g, b) ((r >> 3) << 11) | ((g >> 2) << 5) | ((b >> 3) << 0);

uint8 cont1=0;
uint8 cont2=0;

int key_x[27];
int key_y[27];
int key_int[27];
int row_begin[4];
int row_end[4];

//--- returns the stat of the given controller ---
int status_controller(int controller_nmbr)
{
	maple_device_t *mcont;
	cont_state_t *cond;


	if (controller_nmbr==1)
		mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	else
		mcont = maple_enum_type(1, MAPLE_FUNC_CONTROLLER);

	//--- error getting status ---
	cond = (cont_state_t *)maple_dev_status(mcont);
	if (!cond)
		{
		return CONTROLLERERROR;
		}

	//--- start button pressed ---
	if (cond->buttons & CONT_START)
		{
		return BTN_START;
		}

	//--- up button pressed ---
	if (cond->buttons & CONT_DPAD_UP)
		{
		return BTN_UP;
		}

	//--- left button pressed ---
	if (cond->buttons & CONT_DPAD_LEFT)
		{
		return BTN_LEFT;
		}

	//--- down button pressed ---
	if (cond->buttons & CONT_DPAD_DOWN)
		{
		return BTN_DOWN;
		}

	//--- right button pressed ---
	if (cond->buttons & CONT_DPAD_RIGHT)
		{
		return BTN_RIGHT;
		}

	//--- A button pressed ---
	if (cond->buttons & CONT_A)
		{
		return BTN_A;
		}
	//--- B button pressed ---
	if (cond->buttons & CONT_B)
		{
		return BTN_B;
		}
	//--- X button pressed ---
	if (cond->buttons & CONT_X)
		{
		return BTN_X;
		}
	//--- Y button pressed ---
	if (cond->buttons & CONT_Y)
		{
		return BTN_Y;
		}

	return 0;
}

//--- this function will read keyboard input, and returns the pressed key ---
//--- note that it also checks for (in)valid characters, and it convert   ---
//--- lowercase to uppercase                                              ---
//--- returnrange = A..Z - <return> - <ESC> - <backspace>                 ---
//--- otherwise returnvalue = 0                                           ---
int keyboard_read()
{
	//uint8 mkb;
	maple_device_t *mkb;
	int k;
	
	mkb = maple_enum_type(0, MAPLE_FUNC_KEYBOARD);
	
	//--- no keyboard attached ---//
	if (!mkb) 
		{
		return 0;
		}
		
	//--- return last key that was pressed ---//
	k = kbd_get_key(); 

	//--- convert lowercase to uppercase ---//
	if (k>96)
		{
		k=k-32;
		}

	if ((k==27) || (k==13) || (k==8) || (k==32) || ((k>64) && (k<91)))
		{
		return k;
		}

	return 0;
}
//--- initialise cordinates for virtual keys ---
void do_keyboard_init(int xpos, int ypos)
{

	//--- init for virtual keyboard ---
	row_begin[1]=1;
	row_end[1]=10;
	row_begin[2]=11;
	row_end[2]=19;
	row_begin[3]=20;
	row_end[3]=26;

	//--- Q ---
	key_x[1]=34+xpos;
	key_y[1]=23+ypos;
	key_int[1]=81;
	//--- W ---
	key_x[2]=55+xpos;
	key_y[2]=23+ypos;
	key_int[2]=87;
	//--- E ---
	key_x[3]=76+xpos;
	key_y[3]=23+ypos;
	key_int[3]=69;
	//--- R ---
	key_x[4]=97+xpos;
	key_y[4]=23+ypos;
	key_int[4]=82;
	//--- T ---
	key_x[5]=118+xpos;
	key_y[5]=23+ypos;
	key_int[5]=84;
	//--- Y ---
	key_x[6]=139+xpos;
	key_y[6]=23+ypos;
	key_int[6]=89;
	//--- U ---
	key_x[7]=161+xpos;
	key_y[7]=23+ypos;
	key_int[7]=85;
	//--- I ---
	key_x[8]=182+xpos;
	key_y[8]=23+ypos;
	key_int[8]=73;
	//--- O ---
	key_x[9]=203+xpos;
	key_y[9]=23+ypos;
	key_int[9]=79;
	//--- P ---
	key_x[10]=224+xpos;
	key_y[10]=23+ypos;
	key_int[10]=80;
	//--- A ---
	key_x[11]=38+xpos;
	key_y[11]=45+ypos;
	key_int[11]=65;
	//--- S ---
	key_x[12]=59+xpos;
	key_y[12]=45+ypos;
	key_int[12]=83;
	//--- D ---
	key_x[13]=80+xpos;
	key_y[13]=45+ypos;
	key_int[13]=68;
	//--- F ---
	key_x[14]=102+xpos;
	key_y[14]=45+ypos;
	key_int[14]=70;
	//--- G ---
	key_x[15]=123+xpos;
	key_y[15]=45+ypos;
	key_int[15]=71;
	//--- H ---
	key_x[16]=144+xpos;
	key_y[16]=45+ypos;
	key_int[16]=72;
	//--- J ---
	key_x[17]=165+xpos;
	key_y[17]=45+ypos;
	key_int[17]=74;
	//--- K ---
	key_x[18]=186+xpos;
	key_y[18]=45+ypos;
	key_int[18]=75;
	//--- L ---
	key_x[19]=207+xpos;
	key_y[19]=45+ypos;
	key_int[19]=76;
	//--- Z ---
	key_x[20]=48+xpos;
	key_y[20]=67+ypos;
	key_int[20]=90;
	//--- X ---
	key_x[21]=69+xpos;
	key_y[21]=67+ypos;
	key_int[21]=88;
	//--- C ---
	key_x[22]=90+xpos;
	key_y[22]=67+ypos;
	key_int[22]=67;
	//--- V ---
	key_x[23]=112+xpos;
	key_y[23]=67+ypos;
	key_int[23]=86;
	//--- B ---
	key_x[24]=133+xpos;
	key_y[24]=67+ypos;
	key_int[24]=66;
	//--- N ---
	key_x[25]=154+xpos;
	key_y[25]=67+ypos;
	key_int[25]=78;
	//--- M ---
	key_x[26]=175+xpos;
	key_y[26]=67+ypos;
	key_int[26]=77;

	return;
}

int virtual_keyboard_read(int current_key)
{
	int x=0;
	int y=0;

	do_keyboard_init(160,338);

	for (x=key_x[current_key];x<key_x[current_key]+21;x++)
		{
		for (y=key_y[current_key];y<key_y[current_key]+21;y++)
			{
			vram_s[x + (640*y)] = RGB565(255,0,0);
			}
		}
	return current_key;
}

