//
// glyphix_image.h (customized version of my dbp_image)
//
// (C)2001 Wauters Kris
// For more information check out http://www.snoozys-dc-stuff.be.tf
//

#ifndef _GLYPHIX_IMAGE_H_
#define _GLYPHIX_IMAGE_H_

#define SCREEN              1
#define BUFFER              2
#define NORMAL              1
#define DOUBLE              2
#define OPAQUE              1
#define TRANSPARANT_RED     2
#define TRANSPARANT_BLACK   3

typedef struct {
	unsigned short    *rect_data;
} Img;

unsigned char *img_load(char *fn);                                                           // preload image in cache
int img_place(unsigned char *img,int xpos,int ypos,int size,int display,int view);  // show image at given cordinates
int img_width(char *img);                                                           // returns the width of the given image
int img_height(char *img);                                                          // returns the height of the given image
unsigned char *img_creationdate(char *img);                                                  // returns the creationdate of the given image
unsigned char *img_copyright(char *img);                                                     // returns the copyright from within the given image
int flush_buffer();                                                                 // copy buffer to screen  
int img_mem_init();                                                                 // create virtual screenbuffer
int init_buffer();                                                                  // clears buffer with specified color
void clear_rectangle(int x,int y,int width, int height,int r, int g, int b);
void put_rectangle(Img *rect,int xpos,int ypos,int rect_pixels);
Img *copy_rectangle(int xpos,int ypos,int rect_pixels);
int dbp_load_from_disc(char *fn, int xpos, int ypos);
#endif

