// Written by Snoozy - http://www.snoozys-dc-stuff.be.tf
//
// Started on sunday, oct 14th - 2001
//
// And resurrected on saturday, sept 25th - 2010

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#include <kos.h>
KOS_INIT_FLAGS(INIT_DEFAULT);
#include "s3mlib.h"
#include "othello.h"
#include "glyphix_image.h"          //--- customized version of my dbp_image                ---//
#include "glyphix_maple.h"          //--- my own layer on top of the libdreams' maple stuff ---//
#include "icon_1.h"
#include "icon_2.h"
#include "icon_3.h"
#include "icon_win.h"
#include "icon_loose.h"
#include "icon_empty.h"

//---------------------------------------------------------------------
int playertype[3];
unsigned char *star;
unsigned char *numbers[11];
unsigned char *pic_human;
unsigned char *pic_dreamcast;
unsigned char *screen_menu;
unsigned char *screen_game;
unsigned char *screen_credit;
unsigned char *screen_wins[4];
unsigned char *button[4];
unsigned char *field_off[4];
unsigned char *field_on[4];
int field[65], cur_x, cur_y, statbuf;
//---------------------------------------------------------------------

int randnum(int limit) { return (rand() & 0x7fffffff) % limit; }

//--------------------------------------------------------------------------
// This function will display put the selected icon on the corresponding vmu
//--------------------------------------------------------------------------
void put_icon_on_vmu(int icontype,int controller_nmbr )
{
	maple_device_t *mvmu;
	
	//uint8 mvmu=0;
	uint8 bitmap[48*32/8] = {0};
	int x, y, xi, xb;

	if (controller_nmbr == 1)
		mvmu = maple_enum_type(0, MAPLE_FUNC_LCD);
	else
		mvmu = maple_enum_type(1, MAPLE_FUNC_LCD);

	if (mvmu){
		for (y=0; y<32; y++)
			{
			for (x=0; x<48; x++) 
				{
				xi = x / 8;
				xb = 0x80 >> (x % 8);
				if (icontype==VMU_1)
					{
					if (icon_1_xpm[(31-y)*48+(47-x)] == '.')
						bitmap[y*(48/8)+xi] |= xb;
					}
				if (icontype==VMU_2)
					{
					if (icon_2_xpm[(31-y)*48+(47-x)] == '.')
						bitmap[y*(48/8)+xi] |= xb;
					}
				if (icontype==VMU_PLAY)
					{
					if (icon_3_xpm[(31-y)*48+(47-x)] == '.')
						bitmap[y*(48/8)+xi] |= xb;
					}
				if (icontype==VMU_WIN)
					{
					if (icon_win_xpm[(31-y)*48+(47-x)] == '.')
						bitmap[y*(48/8)+xi] |= xb;
					}
				if (icontype==VMU_LOOSE)
					{
					if (icon_loose_xpm[(31-y)*48+(47-x)] == '.')
						bitmap[y*(48/8)+xi] |= xb;
					}
				if (icontype==VMU_EMPTY)
					{
					if (icon_empty_xpm[(31-y)*48+(47-x)] == '.')
						bitmap[y*(48/8)+xi] |= xb;
					}
				}
			}
		vmu_draw_lcd(mvmu, bitmap);
	}
}

//---------------------------------------------------------------------
// put the given piece on the selected cordinates on the board
//---------------------------------------------------------------------
void place_field(int x_pos, int y_pos,int piece)
{
	int actual_x = 0, actual_y = 0;

	actual_x = (x_pos*42)+110;
	actual_y = (y_pos*42)+25;
	statbuf = img_place(field_off[piece],actual_x+4,actual_y+9,NORMAL,SCREEN,OPAQUE);
}

//---------------------------------------------------------------------
// turn cursor on or off at selected position
//---------------------------------------------------------------------
void set_cursor(int x_pos,int y_pos,int action)
{
	int actual_x = 0, actual_y = 0;

	actual_x = (x_pos*42)+110;
	actual_y = (y_pos*42)+25;
	//--- turn cursor on ---
	if (action==C_SET)
		statbuf = img_place(field_on[field[(y_pos*8)-8+x_pos]],actual_x+4,actual_y+9,NORMAL,SCREEN,OPAQUE);
	//--- turn cursor off ---
	if (action==C_UNSET)
		statbuf = img_place(field_off[field[(y_pos*8)-8+x_pos]],actual_x+4,actual_y+9,NORMAL,SCREEN,OPAQUE);
}

//---------------------------------------------------------------------
// routine to check if capture is possible
//---------------------------------------------------------------------
int check_capture(int plt,int x_pos, int y_pos,int xr, int yr, int action)
{
	int capture = 0, x = 0, y = 0, cx = 0, cy = 0, capture_ok = FALSE;
	int enclosure_color = F_WHITE, end_color = F_BLACK;
	if (plt==1)
		{
		enclosure_color = F_BLACK;
		end_color = F_WHITE;
		}
	x = x_pos+xr;
	y = y_pos+yr;
	if ((x>0) && (x<9) && (y>0) && (y<9))
		{
		if (field[(y*8)-8+x]==enclosure_color)
			{
			capture = 1;
			while ((x > 0) && (x < 9) && (y > 0) && (y < 9))
				{
				if ((field[(y*8)-8+x]==enclosure_color) && (capture>0))
					capture++;
				if ((field[(y*8)-8+x]==F_EMPTY) && (capture_ok == FALSE))
					capture=0;
				if ((field[(y*8)-8+x]==end_color) && (capture>0))
					{
					capture_ok = TRUE;
					if (action == TRUE)
						{
						cx = x_pos+xr;
						cy = y_pos+yr;
						while ((cx!=x) || (cy!=y))
							{
							field[(cy*8)-8+cx]=end_color;
							place_field(cx,cy,end_color);
							cx=cx+xr;
							cy=cy+yr;
							}
						}
					}
				x=x+xr;
				y=y+yr;
				}
			}
		}
	if (capture_ok!=TRUE) 
		capture = 0;

	return capture;
}
//---------------------------------------------------------------------
// routine to put correct score onscreen 
//---------------------------------------------------------------------
void do_score()
{
	int xx = 0, yy = 0,score_1 = 0, score_2 = 0;

	//--- count score ---
	for(xx=1;xx<=8;xx++)
		{
		for(yy=1;yy<=8;yy++)
			{
			if (field[(yy*8)-8+xx]==F_WHITE)
				score_1++;
			if (field[(yy*8)-8+xx]==F_BLACK)
				score_2++;
			}
	   }
	//--- put scores on screen ---
	statbuf = img_place(numbers[(score_1/10)+1],52,296,NORMAL,SCREEN,OPAQUE);
	statbuf = img_place(numbers[score_1-((score_1/10)*10)+1],52+27,296,NORMAL,SCREEN,OPAQUE);

	statbuf = img_place(numbers[(score_2/10)+1],539,296,NORMAL,SCREEN,OPAQUE);
	statbuf = img_place(numbers[score_2-((score_2/10)*10)+1],539+27,296,NORMAL,SCREEN,OPAQUE);
}

//---------------------------------------------------------------------
// routine to validate human moves
//---------------------------------------------------------------------
int validate_move(int plx, int x_pos, int y_pos,int act)
{
	int goforit = FALSE, captured_nmbr = 0;
	//--- field must be empty ---
	if (field[(y_pos*8)-8+x_pos]==F_EMPTY)
		{
		//--- all directions ---
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,1,0,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,1,1,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,0,1,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,-1,1,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,-1,0,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,-1,-1,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,0,-1,act);
		captured_nmbr = captured_nmbr + check_capture(plx,x_pos,y_pos,1,-1,act);
		}

	if (captured_nmbr > 0)
		{
		goforit = TRUE;
		if ((plx ==1) && (act==TRUE))
			{
			field[(y_pos*8)-8+x_pos] = F_WHITE;
			place_field(x_pos,y_pos,F_WHITE);        
			}
		if ((plx ==2) && (act==TRUE))
			{
			field[(y_pos*8)-8+x_pos] = F_BLACK;
			place_field(x_pos,y_pos,F_BLACK);        
			}
		do_score();
		}
	//---return TRUE when move is valid
	//---return FALSE when move is invalid
	return goforit;
}

//---------------------------------------------------------------------
// check game score and possible end of game
//---------------------------------------------------------------------
int check_game()
{
	//--- return 0 = next move still possible ---
	//--- return 1 = player one wins          ---
	//--- return 2 = player two wins          ---
	//--- return 3 = game ended "even"        ---
	int returnvalue = 0, xm = 0, ym = 0;
	int score_1 = 0, score_2 = 0, xc = 0, yc = 0;
	int valid = FALSE;
	for(xm=1;xm<=8;xm++)
		{
		for(ym=1;ym<=8;ym++)
			{
			if (field[(ym*8)-8+xm]==F_EMPTY)
				{
				statbuf = validate_move(1,xm,ym,FALSE);
				if (statbuf == TRUE)
					valid = TRUE;
				statbuf = validate_move(2,xm,ym,FALSE);
				if (statbuf == TRUE)
					valid = TRUE;
				}
			}
		}

	//--- game over ---
	if (valid == FALSE)
	{
		//--- count score ---
		for(xc=1;xc<=8;xc++)
			{
			for(yc=1;yc<=8;yc++)
				{
				if (field[(yc*8)-8+xc]==F_WHITE)
					score_1++;
				if (field[(yc*8)-8+xc]==F_BLACK)
					score_2++;
				}
			}
		if (score_1>score_2)
			returnvalue = 1;
		if (score_1<score_2)
			returnvalue = 2;
		if (score_1==score_2)
			returnvalue = 3;
	}

	return returnvalue;
}

//---------------------------------------------------------------------
// check if current player can do a valid move
//---------------------------------------------------------------------
int check_possible_move(int player)
{
	int xm = 0, ym = 0;
	int valid = FALSE;
	for(xm=1;xm<=8;xm++)
		{
		for(ym=1;ym<=8;ym++)
			{
			if (field[(ym*8)-8+xm]==F_EMPTY)
				{
				statbuf = validate_move(player,xm,ym,FALSE);
				if (statbuf == TRUE)
					valid = TRUE;
				}
			}
		}
	return valid;
}

//---------------------------------------------------------------------
// routine to handle moves
//---------------------------------------------------------------------
int do_move(int player,int gametype)
{
	int pos_x = cur_x, pos_y = cur_y, old_pos_x = 10, old_pos_y = 10, holdon = 0;
	int tmpstat = 0, cont_nmbr = 0;
	int dc_valid_move = FALSE;

	tmpstat = check_possible_move(player);
	if (tmpstat==TRUE)
		{    
		//--- put star under the score of the actual player that is on move ---
		if (player==1)
			{
			statbuf = img_place(star,34,342,NORMAL,SCREEN,OPAQUE);            
			clear_rectangle(522,342,80,80,255,255,255);
			}
		if (player==2)
			{
			statbuf = img_place(star,522,342,NORMAL,SCREEN,OPAQUE);            
			clear_rectangle(34,342,80,80,255,255,255);
			}

		//--- dreamcast move ---
		if (playertype[player] == P_DREAMCAST)
			{
			while (dc_valid_move == FALSE)
				{
				pos_x = randnum(9);
				pos_y = randnum(9);
				if ((pos_x > 0) && (pos_x < 9) && (pos_y > 0) && (pos_y < 9))
					{
					if (field[(pos_y*8)-8+pos_x]==F_EMPTY)
						{
						dc_valid_move = validate_move(player,pos_x,pos_y,TRUE);
						}
					}
				//--- move is possible ---
				if (dc_valid_move==TRUE)
					{
					old_pos_x = 10;
					old_pos_y = 10;
					holdon = 1;
					}
				if (pos_x<1)
					pos_x=1;
				if (pos_x>8)
					pos_x=8;
				if (pos_y<1)
					pos_y=1;
				if (pos_y>8)
					pos_y=8;
				}
			}

		//--- human move ---
		if (playertype[player] == P_HUMAN)
			{
			cont_nmbr = player;
			if (playertype[3-player] == P_DREAMCAST)
				cont_nmbr = 1;
			//--- repeat moving on board until selection is made (A or X) ---
			while (holdon == 0)
				{
				vid_waitvbl();
				
				//KOS: Using thd_sleep
				thd_sleep(150);
				
				//--- move cursor ---
				//--- only place cursor when moved or on first loop ---
				if ((old_pos_x != pos_x) || (old_pos_y != pos_y))
					{
					//--- only unset cursor after a move ---
					if ((old_pos_x != 10) && (old_pos_y!=10))
						set_cursor(old_pos_x,old_pos_y,C_UNSET);
					set_cursor(pos_x,pos_y,C_SET);
					old_pos_x = pos_x;
					old_pos_y = pos_y;
					}
				//--- interprete controller data ---
				//--- move cursor position       ---
				if (status_controller(cont_nmbr)==BTN_UP)
					pos_y--;
				if (status_controller(cont_nmbr)==BTN_DOWN)
					pos_y++;
				if (status_controller(cont_nmbr)==BTN_LEFT)
					pos_x--;
				if (status_controller(cont_nmbr)==BTN_RIGHT)
					pos_x++;
				//--- exit game ---
				if (status_controller(cont_nmbr)==BTN_X)
					holdon = 4;
				//--- selection made ---
				if (status_controller(cont_nmbr)==BTN_A)
					{
					//--- check if move is possible ---
					statbuf = validate_move(player,pos_x,pos_y,TRUE);
					//--- move is possible ---
					if (statbuf==TRUE)
						{
						old_pos_x = 10;
						old_pos_y = 10;
						holdon = 1;
						}
					//--- red warning if illegal move ---
					if (statbuf==FALSE)
						{
						clear_rectangle((pos_x*42)+115,(pos_y*42)+35,38,38,255,0,0);
						vid_waitvbl();
						//KOS: Using thd_sleep
						thd_sleep(400);
						vid_waitvbl();
						set_cursor(pos_x,pos_y,C_SET);
						}
					}
					//--- check board boundaries ---
				if (pos_x<1)
					pos_x=1;
				if (pos_x>8)
					pos_x=8;
				if (pos_y<1)
					pos_y=1;
				if (pos_y>8)
					pos_y=8;
				}
			}

		//--- exit ---
		if (holdon ==1)
			{
			//--- check if next moves are possible or if game is over ---
			//--- statbuf needs to be 0 is next move is possible         ---
			//--- statbuf needs to be 1 if player one did win            ---
			//--- statbuf needs to be 2 if player two did win            ---
			//--- statbuf needs to be 3 if game is even, nobody wins     ---
			statbuf = check_game();
			if (statbuf==0)
				cur_x = pos_x;
				cur_y = pos_y;
			}
		if (holdon != 1)
			statbuf = holdon;
	}
	if (tmpstat == FALSE)
		statbuf = 0;

	return statbuf;
}

//---------------------------------------------------------------------
// actual game
//---------------------------------------------------------------------
int do_gameplay(int gametype)
{
	int x = 0, y = 0,current_stat = 0,randomnmbr = 0;

	//--- place correct icons, (e.g. human / dreamcast) ---
	statbuf = img_place(screen_game,5,10,NORMAL,SCREEN,OPAQUE);
	if (gametype==1)
		{
		put_icon_on_vmu(VMU_1,1);
		put_icon_on_vmu(VMU_2,2);
		playertype[1]=P_HUMAN;
		playertype[2]=P_HUMAN;
		statbuf = img_place(pic_human,6,76,NORMAL,SCREEN,OPAQUE);
		statbuf = img_place(pic_human,491,76,NORMAL,SCREEN,OPAQUE);
		}
	//--- randomize human / dreamcast position ---
	else if (gametype == 2)
		{
		put_icon_on_vmu(VMU_PLAY,1);
		put_icon_on_vmu(VMU_EMPTY,2);
		randomnmbr = randnum(3);
		if (randomnmbr==0)
			{
			playertype[1]=P_DREAMCAST;
			playertype[2]=P_HUMAN;
			statbuf = img_place(pic_dreamcast,6,76,NORMAL,SCREEN,OPAQUE);
			statbuf = img_place(pic_human,491,76,NORMAL,SCREEN,OPAQUE);
			}
		if (randomnmbr>0)
			{
			playertype[1]=P_HUMAN;
			playertype[2]=P_DREAMCAST;
			statbuf = img_place(pic_human,6,76,NORMAL,SCREEN,OPAQUE);
			statbuf = img_place(pic_dreamcast,491,76,NORMAL,SCREEN,OPAQUE);
			}
		}
	//--- create empty playfield ---
	for(x=1;x<=8;x++)
		{
		for(y=1;y<=8;y++)
			{
			place_field(x,y,F_EMPTY);
			field[(y*8)-8+x] = F_EMPTY;
			}
		}
	//---place 4 starpieces on board ---
	place_field(4,4,F_WHITE);
	place_field(5,5,F_WHITE);
	place_field(5,4,F_BLACK);
	place_field(4,5,F_BLACK);
	//--- place 4 starpieces in memory ---
	field[(4*8)-8+4]=F_WHITE;
	field[(5*8)-8+5]=F_WHITE;
	field[(4*8)-8+5]=F_BLACK;
	field[(5*8)-8+4]=F_BLACK;
	//--- set starposition of cursor to topleft ---
	cur_x=1;
	cur_y=1;
	//-------------------------------
	//--- actual mainloop of game ---
	//-------------------------------
	current_stat = 0;
	while (current_stat==0)
		{
		current_stat = do_move(1,gametype);
		if (current_stat==0)
			current_stat = do_move(2,gametype);
		}
	//--- current_stat=0    =>  stay in game
	//--- current_stat=1    =>  player one did win
	//--- current_stat=2    =>  player two did win
	//--- current_stat=3    =>  game even, nobody win
	//--- current_stat=4    =>  X-button pressed to exit game
	if ((current_stat>0) && (current_stat<4))
		{
		//--- show corresponding info on VMU ---
		if (gametype==1)
			{
			if (current_stat==1)
				{
				put_icon_on_vmu(VMU_WIN,1);
				put_icon_on_vmu(VMU_LOOSE,2);
				}
			if (current_stat == 2)
				{
				put_icon_on_vmu(VMU_WIN,2);
				put_icon_on_vmu(VMU_LOOSE,1);
				}
			}
		else if (gametype==2)
			{
			if ((playertype[1]==P_HUMAN) && current_stat==1)
				put_icon_on_vmu(VMU_WIN,1);
			if ((playertype[1]==P_HUMAN) && current_stat==2)
				put_icon_on_vmu(VMU_LOOSE,1);
			if ((playertype[2]==P_HUMAN) && current_stat==2)
				put_icon_on_vmu(VMU_WIN,1);
			if ((playertype[2]==P_HUMAN) && current_stat==1)
				put_icon_on_vmu(VMU_LOOSE,1);
			}
		statbuf = s3m_play("MUSIC/2.S3M");
		vid_clear(255,255,255);
		statbuf = img_place(screen_wins[current_stat],5,10,NORMAL,SCREEN,OPAQUE);
		while ((status_controller(1)!=BTN_START) && (status_controller(1)!=BTN_A) && (status_controller(1)!=BTN_B) && (status_controller(1)!=BTN_X) && (status_controller(1)!=BTN_Y) && (status_controller(2)!=BTN_START) && (status_controller(2)!=BTN_A) && (status_controller(2)!=BTN_B) && (status_controller(2)!=BTN_X) && (status_controller(2)!=BTN_Y))
			{
			//KOS: Using thd_sleep
			thd_sleep(10);
			}
		//--- statbuf = true means that s3m file is actually playing ---
		//--- so it don't need to be started again                ---
		statbuf = TRUE;
		}
		//--- exit to menu ---
		//--- current_stat = 4 means that X button is pressed to exit game ---
		//--- S3M file needs to be started                                 ---
		if (current_stat==4)
			statbuf = FALSE;

	return statbuf;
}

//---------------------------------------------------------------------
// mainmenu
//---------------------------------------------------------------------
void do_mainmenu()
{
	int x = 1, old_x = 0,main_stat = FALSE, pos_y[4];

	pos_y[1] = 160;
	pos_y[2] = 244;
	pos_y[3] = 328;

	//--- main loop ---
	while (1)
		{
		vid_waitvbl();
		//KOS: Using thd_sleep
		thd_sleep(25);
		//--- only update screen when moved or on first time in while-loop ---
		if (x!=old_x)
			{
			statbuf = img_place(screen_menu,5,10,NORMAL,SCREEN,OPAQUE);
			statbuf = img_place(button[x],198,pos_y[x],NORMAL,SCREEN,OPAQUE);
			old_x = x;
			}
		//--- change position in menu, depending on buttons pressed ---
		if ((status_controller(1)==BTN_UP) || (status_controller(2)==BTN_UP))
			x--;
		if ((status_controller(1)==BTN_DOWN) || (status_controller(2)==BTN_DOWN))
			x++;
		//--- selection made in menu ---
		if ((status_controller(1)==BTN_A) || (status_controller(2)==BTN_A))
			{
			main_stat=TRUE;
			//--- start gameplay with parameter (human/human or human/dc) ---
			if ((x==1) || (x==2))
				{
				//snd_stop_arm();
				spu_disable();
				//--- stay in gameplay until game over or exit game ---
				main_stat = do_gameplay(x);
				
				//2010: No need to free images (all are loaded once in do_intro)
				
				//--- put Othello logo on LCD ---
				put_icon_on_vmu(VMU_EMPTY,1);
				put_icon_on_vmu(VMU_EMPTY,2);
				//--- S3M not running, start S3M ---
				if (main_stat == FALSE)
					statbuf = s3m_play("MUSIC/2.S3M");
				//--- clears screen and put old_x to unused value, so ---
				//--- the menu will be displayed again                ---
				vid_clear(255,255,255);
				old_x = 0;
				}
			//--- show creditscreen ---
			if (x == 3)
				{
				statbuf = img_place(screen_credit,5,10,NORMAL,SCREEN,OPAQUE);
				//KOS: Using thd_sleep
				thd_sleep(400);
				//--- wait in creditscreen until button is pressed ---
				while ((status_controller(1)!=BTN_A) && (status_controller(1)!=BTN_B) && (status_controller(2)!=BTN_A) && (status_controller(2)!=BTN_B))
					{
					//KOS: Using thd_sleep
					thd_sleep(10);
					}
				//KOS: Using thd_sleep
				thd_sleep(400);
				old_x = 0;
				}
			}
			if (x<1)
				x=1;
			if (x>3)
				x=3;
	}
}

//---------------------------------------------------------------------
//introscreen => preloading data into memory and waits until the
//               start button is pressed ...
//---------------------------------------------------------------------
void do_intro()
{
	unsigned char *screen_title;
	unsigned char *preload_txt;
	unsigned char *start_txt;
	int x;
	char num[6], filename[30];

	vid_clear(255,255,255);

	//--- create introductionscreen and show preloading text ---
	screen_title= img_load("SCREENS/S_TITLE.DBP");
	preload_txt = img_load("TEXT/T_LOAD.DBP");
	start_txt   = img_load("TEXT/T_START.DBP");
	statbuf = s3m_play("MUSIC/5.S3M");
	statbuf = img_place(screen_title,5,10,NORMAL,SCREEN,OPAQUE);
	statbuf = img_place(preload_txt,144,415,NORMAL,SCREEN,OPAQUE);

	//--- preload graphics ---
	//--- numbers
	for(x=1;x<=10;x++)
		{
		num[0] = (x-1)+48; //Ascii conversion
		num[1] = '.';
		num[2] = 'D';
		num[3] = 'B';
		num[4] = 'P';
		num[5] = '\0';
		strcpy(filename,"NUMBERS/");
		strcat(filename,num);
		numbers[x] = img_load(filename);
		}

	//--- pics ---
	pic_human       = img_load("PICTURES/P_HUMAN.DBP");
	pic_dreamcast   = img_load("PICTURES/P_DC.DBP");
	star            = img_load("PICTURES/STAR.DBP");
	//--- complete screens ---
	screen_menu    = img_load("SCREENS/S_MENU.DBP");
	screen_game    = img_load("SCREENS/S_GAME.DBP");
	screen_credit  = img_load("SCREENS/S_CREDIT.DBP");
	screen_wins[1] = img_load("SCREENS/S_WIN_1.DBP");
	screen_wins[2] = img_load("SCREENS/S_WIN_2.DBP");
	screen_wins[3] = img_load("SCREENS/S_NO_WIN.DBP");
	//--- buttons ---
	button[2] = img_load("BUTTONS/B_1_MENU.DBP");
	button[1] = img_load("BUTTONS/B_2_MENU.DBP");
	button[3] = img_load("BUTTONS/B_3_MENU.DBP");
	//--- playfield pieces ---
	field_off[F_EMPTY] = img_load("FIELDS/V_LEEG0.DBP");
	field_on[F_EMPTY]  = img_load("FIELDS/V_LEEG1.DBP");
	field_off[F_WHITE] = img_load("FIELDS/V_WIT0.DBP");
	field_on[F_WHITE]  = img_load("FIELDS/V_WIT1.DBP");
	field_off[F_BLACK] = img_load("FIELDS/V_ZWART0.DBP");
	field_on[F_BLACK]  = img_load("FIELDS/V_ZWART1.DBP");

	//--- preloading done ---
	//--- show startbutton and wait for start to be pressed ---
	clear_rectangle(5,415,620,65,255,255,255);
	statbuf = img_place(start_txt,89,415,NORMAL,SCREEN,OPAQUE);

	while ((status_controller(1)!=BTN_START) && (status_controller(2)!=BTN_START))
		{
			thd_sleep(10);
		}
	vid_clear(255,255,255);
	free(start_txt); //free image
	return;
}

//---------------------------------------------------------------------
// main function, this is where all the fun starts ;-)
//---------------------------------------------------------------------
int main()
{
	//--- Initialise video - ooh yeah, 640x480,RGB565 is my favorite ;-)
	vid_set_mode(DM_640x480_PAL_IL,PM_RGB565);
	
	vid_clear(255,255,255);
	vid_border_color(255,255,255);
	img_mem_init();
	statbuf = init_buffer(255,255,255);

	//--- put othello logo on LCD ---
	put_icon_on_vmu(VMU_EMPTY,1);
	put_icon_on_vmu(VMU_EMPTY,2);
	
	//--- KOS function to redirect to CD ---
	fs_chdir("/cd/othello");
	
	//-- Init random seed generator
	srand(time(NULL));

	//--- perform introscreen
	do_intro();

	//--- show main menu
	do_mainmenu();

	return 0;
}


